/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http.server;

import io.intino.alexandria.http.pushservice.Client;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WriteCallback;

public class AlexandriaHttpClient
implements Client {
    private Session session;
    private final Map<String, String> queryString;
    private String language = null;
    private Integer timezoneOffset = null;
    private final List<String> messagesQueue = new ArrayList<String>();
    private Timer queueTimer;

    public AlexandriaHttpClient(Session session) {
        this.session = session;
        this.queryString = AlexandriaHttpClient.parseQueryString(session.getUpgradeRequest().getRequestURI().getQuery());
        this.runQueueManager();
    }

    public Session session() {
        return this.session;
    }

    public AlexandriaHttpClient session(Session session) {
        this.session = session;
        return this;
    }

    public static String sessionId(Session session) {
        Map<String, String> queryString = AlexandriaHttpClient.parseQueryString(session.getUpgradeRequest().getRequestURI().getQuery());
        return queryString.get("currentSession");
    }

    @Override
    public String id() {
        return this.queryString.get("id");
    }

    @Override
    public String sessionId() {
        return AlexandriaHttpClient.sessionId(this.session);
    }

    @Override
    public String language() {
        return this.language != null ? this.language : this.queryString.get("language");
    }

    @Override
    public void language(String language) {
        this.language = language;
    }

    @Override
    public int timezoneOffset() {
        return this.timezoneOffset != null ? this.timezoneOffset : (this.queryString.containsKey("tzo") ? Integer.parseInt(this.queryString.get("tzo")) : 0);
    }

    public void timezoneOffset(int value) {
        this.timezoneOffset = value;
    }

    @Override
    public boolean send(final String message) {
        if (!this.session.isOpen()) {
            return false;
        }
        try {
            RemoteEndpoint remote = this.session.getRemote();
            remote.sendString(message, new WriteCallback(){

                public void writeFailed(Throwable throwable) {
                    if (!AlexandriaHttpClient.this.messagesQueue.contains(message)) {
                        AlexandriaHttpClient.this.messagesQueue.add(message);
                    }
                }

                public void writeSuccess() {
                    if (AlexandriaHttpClient.this.messagesQueue.contains(message)) {
                        AlexandriaHttpClient.this.messagesQueue.remove(message);
                    }
                }
            });
            remote.flush();
        }
        catch (IOException ignored) {
            return false;
        }
        return true;
    }

    @Override
    public void destroy() {
        this.queueTimer.cancel();
        this.messagesQueue.clear();
    }

    public int hashCode() {
        return this.sessionId().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof AlexandriaHttpClient && this.id().equals(((AlexandriaHttpClient)obj).id());
    }

    private static Map<String, String> parseQueryString(String queryString) {
        return Stream.of(queryString.split("&")).map(param -> param.split("=")).collect(Collectors.toMap(p -> p[0], p -> ((String[])p).length > 1 ? p[1] : "", (a, b) -> a));
    }

    private void runQueueManager() {
        this.queueTimer = new Timer("alexandria http queue timer");
        this.queueTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!AlexandriaHttpClient.this.session.isOpen()) {
                    AlexandriaHttpClient.this.messagesQueue.clear();
                }
                AlexandriaHttpClient.this.messagesQueue.forEach(message -> AlexandriaHttpClient.this.send((String)message));
            }
        }, 1000L, 1000L);
    }
}

