/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http.javalin;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.http.AlexandriaHttpServer;
import io.intino.alexandria.http.javalin.JavalinHttpRequest;
import io.intino.alexandria.http.javalin.JavalinHttpResponse;
import io.intino.alexandria.http.pushservice.PushService;
import io.intino.alexandria.http.pushservice.PushServiceHandler;
import io.intino.alexandria.http.server.AlexandriaHttpManager;
import io.intino.alexandria.http.server.AlexandriaHttpRequest;
import io.intino.alexandria.http.server.AlexandriaHttpResourceProvider;
import io.intino.alexandria.http.server.AlexandriaHttpResponse;
import io.intino.alexandria.http.server.AlexandriaHttpRouter;
import io.intino.alexandria.logger.Logger;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.HttpResponseException;
import io.javalin.http.UploadedFile;
import io.javalin.websocket.WsConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class JavalinHttpRouter<SM extends AlexandriaHttpManager<?>>
implements AlexandriaHttpRouter<SM> {
    private final String path;
    private final Javalin service;
    private final List<String> webDirectories;
    private AlexandriaHttpRouter.ManagerProvider<SM> managerProvider;
    protected PushService<?, ?> pushService;
    private Function<AlexandriaHttpManager<?>, Boolean> validator = null;
    private Consumer<PushService<?, ?>> pushServiceConsumer = null;
    private static final Set<String> Paths = new HashSet<String>();

    public JavalinHttpRouter(Javalin service, String path, List<String> webDirectories) {
        this.service = service;
        this.path = path;
        this.webDirectories = webDirectories;
        this.managerProvider = this::defaultManager;
    }

    @Override
    public JavalinHttpRouter<SM> before(AlexandriaHttpServer.ResourceCaller<SM> caller) {
        if (!this.canRegister(this.path, "before")) {
            return this;
        }
        this.service.before(JavalinHttpRouter.adapt(this.path), context -> this.before(caller, (AlexandriaHttpManager<?>)this.manager(context)));
        return this;
    }

    @Override
    public JavalinHttpRouter<SM> get(AlexandriaHttpServer.ResourceCaller<SM> caller) {
        if (!this.canRegister(this.path, "get")) {
            return this;
        }
        this.service.get(JavalinHttpRouter.adapt(this.path), context -> this.execute(caller, (AlexandriaHttpManager)this.manager(context)));
        return this;
    }

    @Override
    public JavalinHttpRouter<SM> post(AlexandriaHttpServer.ResourceCaller<SM> caller) {
        if (!this.canRegister(this.path, "post")) {
            return this;
        }
        this.service.post(JavalinHttpRouter.adapt(this.path), context -> this.execute(caller, (AlexandriaHttpManager)this.manager(context)));
        return this;
    }

    @Override
    public JavalinHttpRouter<SM> put(AlexandriaHttpServer.ResourceCaller<SM> caller) {
        if (!this.canRegister(this.path, "put")) {
            return this;
        }
        this.service.put(JavalinHttpRouter.adapt(this.path), context -> this.execute(caller, (AlexandriaHttpManager)this.manager(context)));
        return this;
    }

    @Override
    public JavalinHttpRouter<SM> delete(AlexandriaHttpServer.ResourceCaller<SM> caller) {
        if (!this.canRegister(this.path, "delete")) {
            return this;
        }
        this.service.delete(JavalinHttpRouter.adapt(this.path), context -> this.execute(caller, (AlexandriaHttpManager)this.manager(context)));
        return this;
    }

    @Override
    public JavalinHttpRouter<SM> patch(AlexandriaHttpServer.ResourceCaller<SM> caller) {
        if (!this.canRegister(this.path, "patch")) {
            return this;
        }
        this.service.patch(JavalinHttpRouter.adapt(this.path), context -> this.execute(caller, (AlexandriaHttpManager)this.manager(context)));
        return this;
    }

    @Override
    public JavalinHttpRouter<SM> after(AlexandriaHttpServer.ResourceCaller<SM> caller) {
        if (!this.canRegister(this.path, "after")) {
            return this;
        }
        this.service.after(JavalinHttpRouter.adapt(this.path), context -> this.after(caller, (AlexandriaHttpManager)this.manager(context)));
        return this;
    }

    @Override
    public PushService<?, ?> pushService() {
        return this.pushService;
    }

    @Override
    public void push(PushService<?, ?> service) {
        this.pushService = service;
    }

    @Override
    public void register(PushService<?, ?> service) {
        this.pushService = service;
        if (this.pushServiceConsumer != null) {
            this.pushServiceConsumer.accept(this.pushService);
        }
        if (!this.canRegister(this.path, "socket")) {
            return;
        }
        this.service.ws(JavalinHttpRouter.adapt(this.path), config -> new PushServiceHandler((WsConfig)config, this.pushService));
    }

    @Override
    public void managerProvider(AlexandriaHttpRouter.ManagerProvider<SM> provider) {
        this.managerProvider = provider;
    }

    @Override
    public void whenRegisterPushService(Consumer<PushService<?, ?>> pushServiceConsumer) {
        this.pushServiceConsumer = pushServiceConsumer;
    }

    @Override
    public void whenValidate(Function<AlexandriaHttpManager<?>, Boolean> validator) {
        this.validator = validator;
    }

    private SM defaultManager(AlexandriaHttpRequest request, AlexandriaHttpResponse response, AlexandriaHttpResourceProvider resourceProvider) {
        return (SM)new AlexandriaHttpManager(this.pushService, request, response, resourceProvider);
    }

    private SM manager(Context context) {
        return this.managerProvider.get(this.request(context), this.response(context), this.resourceProvider(context));
    }

    private boolean validRequest(AlexandriaHttpManager<?> manager) {
        return this.validator != null ? this.validator.apply(manager) : true;
    }

    private void before(AlexandriaHttpServer.ResourceCaller<SM> caller, AlexandriaHttpManager<?> manager) {
        try {
            caller.call(manager);
        }
        catch (AlexandriaException e) {
            throw new HttpResponseException(Integer.parseInt(e.code()), e.toString());
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            manager.response().error(500, e.toString());
        }
    }

    private void execute(AlexandriaHttpServer.ResourceCaller<SM> caller, AlexandriaHttpManager manager) {
        if (!this.validRequest(manager)) {
            return;
        }
        this.call(caller, manager);
    }

    private void after(AlexandriaHttpServer.ResourceCaller<SM> caller, AlexandriaHttpManager manager) {
        this.call(caller, manager);
    }

    private void call(AlexandriaHttpServer.ResourceCaller<SM> caller, AlexandriaHttpManager manager) {
        try {
            caller.call(manager);
        }
        catch (AlexandriaException e) {
            manager.response().error(Integer.parseInt(e.code()), e.toString());
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            manager.response().error(500, e.toString());
        }
    }

    private AlexandriaHttpRequest request(Context context) {
        return new JavalinHttpRequest(context);
    }

    private AlexandriaHttpResponse response(Context context) {
        return new JavalinHttpResponse(context);
    }

    private AlexandriaHttpResourceProvider resourceProvider(final Context context) {
        return new AlexandriaHttpResourceProvider(){

            @Override
            public List<String> webDirectories() {
                return JavalinHttpRouter.this.webDirectories;
            }

            @Override
            public List<Resource> resources() {
                return context.uploadedFiles().stream().map(f -> new Resource(f.filename(), f.content()).metadata().contentType(f.contentType())).collect(Collectors.toList());
            }

            @Override
            public Resource resource(String name) {
                UploadedFile file = context.uploadedFile(name);
                return file != null ? new Resource(file.filename(), file.content()).metadata().contentType(file.contentType()) : null;
            }
        };
    }

    private static String adapt(String path) {
        String regex = ":(\\w+)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(path);
        return matcher.replaceAll("{$1}");
    }

    private boolean canRegister(String path, String suffix) {
        if (Paths.contains(path + suffix)) {
            return false;
        }
        Paths.add(path + suffix);
        return true;
    }
}

