/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http.javalin;

import io.intino.alexandria.http.server.AlexandriaHttpRequest;
import io.javalin.http.Context;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class JavalinHttpRequest
implements AlexandriaHttpRequest {
    private final Context context;

    public JavalinHttpRequest(Context context) {
        this.context = context;
    }

    @Override
    public String sessionId() {
        return this.context.req().getSession().getId();
    }

    @Override
    public String uri() {
        return this.context.req().getRequestURI();
    }

    @Override
    public String header(String name) {
        return this.context.header(name);
    }

    @Override
    public Map<String, String> headers() {
        return this.context.headerMap();
    }

    @Override
    public Map<String, String> cookies() {
        return this.context.cookieMap();
    }

    @Override
    public String cookie(String name) {
        return this.context.cookie(name);
    }

    @Override
    public List<String> queryParams() {
        HashSet result = new HashSet(this.context.queryParamMap().keySet());
        result.addAll(this.context.formParamMap().keySet());
        result.addAll(this.context.req().getParameterMap().keySet());
        return new ArrayList<String>(result);
    }

    @Override
    public List<String> queryParams(String key) {
        ArrayList<String> result = new ArrayList<String>(this.context.queryParams(key));
        if (result.isEmpty()) {
            result.addAll(this.context.formParams(key));
        }
        if (result.isEmpty()) {
            result.add(this.context.req().getParameter(key));
        }
        return result;
    }

    @Override
    public String queryParam(String key) {
        String result = this.context.queryParam(key);
        result = result != null ? result : this.context.formParam(key);
        result = result != null ? result : this.context.req().getParameter(key);
        return result;
    }

    @Override
    public String queryString() {
        return this.context.queryString();
    }

    @Override
    public String pathParam(String name) {
        return this.context.pathParamMap().getOrDefault(name, null);
    }

    @Override
    public String body() {
        return this.context.body();
    }

    @Override
    public byte[] bodyAsBytes() {
        return this.context.bodyAsBytes();
    }

    @Override
    public String ip() {
        return this.context.ip();
    }

    @Override
    public HttpServletRequest raw() {
        return this.context.req();
    }
}

