/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http.server;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.AlexandriaError;
import io.intino.alexandria.http.MimeTypes;
import io.intino.alexandria.http.server.AlexandriaHttpResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;

class AlexandriaHttpWriter {
    private final AlexandriaHttpResponse response;

    AlexandriaHttpWriter(AlexandriaHttpResponse response) {
        this.response = response;
    }

    void write(Object object) {
        this.write(object, null);
    }

    void write(Object object, String name) {
        this.write(object, name, false);
    }

    void write(Object object, String name, boolean embedded) {
        if (object instanceof File) {
            this.writeFile((File)object, embedded);
        } else if (object instanceof Resource) {
            this.writeResource((Resource)object, embedded);
        } else if (object instanceof InputStream) {
            this.writeStream((InputStream)object, name, embedded);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object, name, embedded);
        } else {
            this.writeResponse(object.toString(), name);
        }
    }

    void writeHeader(String name, String value) {
        this.response.header(name, value != null ? value : "");
    }

    private void writeResponse(String message, String contentType) {
        try {
            this.writeResponse(message, contentType, this.response.raw());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeError(AlexandriaError response, String message) {
        try {
            this.writeResponseError(response.code(), message, this.response.raw());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeFile(File file, boolean embedded) {
        this.writeResponse(file, embedded, this.response.raw());
    }

    private void writeStream(InputStream stream, String filename, boolean embedded) {
        this.writeResponse(filename, stream, embedded, this.response.raw());
    }

    private void writeResource(Resource resource, boolean embedded) {
        this.writeResponse(resource, embedded, this.response.raw());
    }

    private void writeBytes(byte[] content, String filename, boolean embedded) {
        if (filename == null) {
            filename = "default.bin";
        }
        this.writeResponse(filename, content, embedded, this.response.raw());
    }

    private void writeResponse(String content, String contentType, HttpServletResponse response) throws IOException {
        response.setHeader("X-Content-Type-Options", "nosniff");
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
        response.setContentType(contentType != null ? contentType : "text/html; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        writer.print(content);
        writer.close();
    }

    private void writeResponse(File file, boolean embedded, HttpServletResponse response) {
        try {
            response.setContentType(MimeTypes.getFromFile(file));
            response.setHeader("Content-Disposition", (embedded ? "inline" : "attachment") + ";filename=\"" + file.getName() + "\"");
            this.writeResponse(this.readFile(file), response);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeResponse(Resource resource, boolean embedded, HttpServletResponse response) {
        try {
            String filename = resource.name();
            String contentType = resource.metadata().contentType();
            response.setContentType(contentType);
            resource.metadata().properties().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
            response.setHeader("Content-Disposition", (embedded ? "inline" : "attachment") + ";filename=\"" + (String)(filename != null ? filename : "resource." + MimeTypes.getExtension(contentType)) + "\"");
            this.writeResponseStream(resource.stream(), response);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeResponse(String filename, InputStream stream, boolean embedded, HttpServletResponse response) {
        try {
            String contentType = filename != null ? MimeTypes.getFromFilename(filename) : "application/octet-stream";
            response.setContentType(contentType);
            response.setHeader("Content-Disposition", (embedded ? "inline" : "attachment") + ";filename=\"" + (String)(filename != null ? filename : "resource." + MimeTypes.getExtension(contentType)) + "\"");
            this.writeResponseStream(stream, response);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeResponseStream(InputStream stream, HttpServletResponse response) throws IOException {
        try (InputStream inputStream = stream;){
            long size = stream.transferTo((OutputStream)response.getOutputStream());
            response.setContentLengthLong(size);
            response.getOutputStream().flush();
        }
    }

    private void writeResponse(String filename, byte[] content, boolean embedded, HttpServletResponse response) {
        response.setContentType(MimeTypes.getFromFilename(filename));
        response.setHeader("Content-Disposition", (embedded ? "inline" : "attachment") + "attachment; filename=\"" + filename + "\"");
        this.writeResponse(content, response);
    }

    private void writeResponse(byte[] content, HttpServletResponse response) {
        try {
            response.setContentLength(content.length);
            response.getOutputStream().write(content);
            response.getOutputStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeResponseError(String code, String error, HttpServletResponse response) throws IOException {
        response.setStatus(Integer.parseInt(code));
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
        response.getWriter().print(error);
        response.flushBuffer();
    }

    private byte[] readFile(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }
}

