/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http.pushservice;

import io.intino.alexandria.http.pushservice.PushService;
import io.intino.alexandria.http.server.AlexandriaHttpClient;
import io.intino.alexandria.logger.Logger;
import io.javalin.websocket.WsConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.common.WebSocketSession;

@WebSocket(maxTextMessageSize=0x500000)
public class PushServiceHandler {
    private final PushService pushService;
    private final Map<String, List<AlexandriaHttpClient>> clientsMap = new HashMap<String, List<AlexandriaHttpClient>>();
    private final Map<String, Timer> closeTimersMap = new HashMap<String, Timer>();
    private static final int CloseTimeout = 86400000;
    private static final int CloseGoingAway = 1001;
    private static final int CloseReadEOF = 1006;
    private static final int MaxTextMessageSize = 0x500000;
    private static final int MaxIdleTimeout = 86400000;

    public PushServiceHandler(WsConfig socket, PushService<?, ?> pushService) {
        this.pushService = pushService;
        this.init(socket);
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        AlexandriaHttpClient client = this.client(session);
        if (client != null) {
            this.cancelClose(session);
            this.client(session).session(session);
        } else {
            this.registerClient(session);
        }
        this.pushService.onOpen(this.client(session));
    }

    @OnWebSocketError
    public void onError(Session session, Throwable error) {
        String sessionId = AlexandriaHttpClient.sessionId(session);
        try {
            if (this.closeTimersMap.containsKey(sessionId)) {
                this.closeTimersMap.get(sessionId).cancel();
                this.closeTimersMap.remove(sessionId);
            }
        }
        catch (Throwable ex) {
            Logger.error((Throwable)ex);
        }
        if (error instanceof EofException) {
            return;
        }
        if (error.getMessage() != null) {
            Logger.debug((String)error.getMessage());
        } else {
            Logger.debug((String)error.toString());
        }
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        String sessionId = AlexandriaHttpClient.sessionId(session);
        this.cancelClose(session);
        if (statusCode == 1001) {
            this.doClose(sessionId, this.client(session));
            return;
        }
        this.doCloseDelayed(session, sessionId);
    }

    @OnWebSocketMessage
    public void onMessage(Session session, String message) {
        AlexandriaHttpClient client = this.client(session);
        if (client == null) {
            session.disconnect();
        }
        this.pushService.onMessage(this.client(session), message);
    }

    protected AlexandriaHttpClient client(Session session) {
        String sessionId = this.id(session);
        if (!this.clientsMap.containsKey(sessionId)) {
            return null;
        }
        String clientId = this.clientId(session);
        return this.clientsMap.get(sessionId).stream().filter(c -> c.id().equals(clientId)).findFirst().orElse(null);
    }

    protected AlexandriaHttpClient registerClient(Session session) {
        String sessionId = this.id(session);
        AlexandriaHttpClient client = (AlexandriaHttpClient)this.pushService.createClient(session);
        if (!this.clientsMap.containsKey(sessionId)) {
            this.clientsMap.put(sessionId, new ArrayList());
        }
        this.clientsMap.get(sessionId).add(client);
        return client;
    }

    private String id(Session session) {
        return AlexandriaHttpClient.sessionId(session);
    }

    private void cancelClose(Session session) {
        String sessionId = this.id(session);
        if (!this.closeTimersMap.containsKey(sessionId)) {
            return;
        }
        this.closeTimersMap.get(sessionId).cancel();
        this.closeTimersMap.remove(sessionId);
    }

    private void doCloseDelayed(Session session, final String sessionId) {
        final AlexandriaHttpClient client = this.client(session);
        if (client != null) {
            this.pushService.onCloseScheduled(client);
        }
        Timer timer = new Timer("Push service delayed close");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PushServiceHandler.this.doClose(sessionId, client);
            }
        }, 86400000L);
        this.closeTimersMap.put(sessionId, timer);
    }

    private void doClose(String sessionId, AlexandriaHttpClient client) {
        if (client != null) {
            this.pushService.onClose(client);
        }
        this.removeClientFromClientsMap(sessionId, client);
        if (!this.closeTimersMap.containsKey(sessionId)) {
            return;
        }
        this.closeTimersMap.get(sessionId).cancel();
        this.closeTimersMap.remove(sessionId);
    }

    private void removeClientFromClientsMap(String sessionId, AlexandriaHttpClient client) {
        AlexandriaHttpClient savedClient;
        if (!this.clientsMap.containsKey(sessionId)) {
            return;
        }
        List<AlexandriaHttpClient> clientList = this.clientsMap.get(sessionId);
        AlexandriaHttpClient alexandriaHttpClient = savedClient = client != null ? (AlexandriaHttpClient)clientList.stream().filter(c -> c.id().equals(client.id())).findFirst().orElse(null) : null;
        if (savedClient != null) {
            this.clientsMap.get(sessionId).remove(savedClient);
        }
        if (this.clientsMap.containsKey(sessionId) && this.clientsMap.get(sessionId).isEmpty()) {
            this.clientsMap.remove(sessionId);
        }
    }

    private void refreshSession(Session session) {
        AlexandriaHttpClient client = this.registerClient(session);
        client.session(session);
        this.pushService.linkToThread(client);
    }

    private String clientId(Session session) {
        String[] params = ((WebSocketSession)session).getCoreSession().getRequestURI().getQuery().split("&");
        if (params.length <= 0) {
            return null;
        }
        String[] split = params[0].split("=");
        return split.length > 1 ? split[1] : null;
    }

    private void init(WsConfig socket) {
        socket.onConnect(context -> {
            context.session.getPolicy().setIdleTimeout(Duration.ofMillis(86400000L));
            context.session.getPolicy().setMaxTextMessageSize(0x500000L);
            this.onConnect(context.session);
        });
        socket.onError(context -> this.onError(context.session, context.error()));
        socket.onClose(context -> this.onClose(context.session, context.status(), context.reason()));
        socket.onMessage(context -> this.onMessage(context.session, context.message()));
    }
}

