/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http;

import io.intino.alexandria.http.AlexandriaHttpServer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class AlexandriaHttpServerBuilder {
    private static AlexandriaHttpServer<?> instance;
    private static int port;
    private static String webDirectory;
    private static long maxResourceSize;
    private static boolean ui;
    private static List<Object> objects;

    public static void setup(int port, String webDirectory) {
        AlexandriaHttpServerBuilder.port = port;
        AlexandriaHttpServerBuilder.webDirectory = webDirectory;
        maxResourceSize = 0x6400000L;
    }

    public static void setup(int port, String webDirectory, long maxFormContentSize) {
        AlexandriaHttpServerBuilder.port = port;
        AlexandriaHttpServerBuilder.webDirectory = webDirectory;
        maxResourceSize = maxFormContentSize;
    }

    public static boolean isUI() {
        return ui;
    }

    public static void setUI(boolean value) {
        ui = value;
    }

    public static AlexandriaHttpServer<?> instance() {
        return instance == null ? (instance = AlexandriaHttpServerBuilder.getInstance()) : instance;
    }

    public static void addParameters(Object ... objs) {
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            objects.add(objs[i]);
        }
    }

    private static AlexandriaHttpServer<?> getInstance() {
        return ui ? AlexandriaHttpServerBuilder.loadUIServer() : new AlexandriaHttpServer(port, webDirectory, maxResourceSize);
    }

    private static AlexandriaHttpServer<?> loadUIServer() {
        try {
            Class<?> aClass = Class.forName("io.intino.alexandria.ui.AlexandriaUiServer");
            Constructor<?> constructor = aClass.getConstructors()[0].getParameterCount() == 4 ? aClass.getConstructors()[0] : aClass.getConstructors()[1];
            return (AlexandriaHttpServer)constructor.newInstance(port, webDirectory, maxResourceSize, !objects.isEmpty() ? objects.get(0) : null);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LoggerFactory.getLogger((String)"ROOT").error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static {
        ui = false;
        objects = new ArrayList<Object>();
    }
}

