/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.http.MimeTypes;
import io.intino.alexandria.http.javalin.JavalinHttpRouter;
import io.intino.alexandria.http.pushservice.PushService;
import io.intino.alexandria.http.security.AlexandriaSecurityManager;
import io.intino.alexandria.http.security.NullSecurityManager;
import io.intino.alexandria.http.server.AlexandriaHttpManager;
import io.intino.alexandria.http.server.AlexandriaHttpRouter;
import io.intino.alexandria.logger.Logger;
import io.javalin.Javalin;
import io.javalin.config.JavalinConfig;
import io.javalin.config.StaticFilesConfig;
import io.javalin.http.Context;
import io.javalin.http.ExceptionHandler;
import io.javalin.http.staticfiles.Location;
import io.javalin.http.staticfiles.ResourceHandler;
import io.javalin.http.staticfiles.StaticFileConfig;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class AlexandriaHttpServer<R extends AlexandriaHttpRouter<?>> {
    private AlexandriaSecurityManager securityManager = new NullSecurityManager();
    protected final List<String> webDirectories = new ArrayList<String>();
    protected final long maxResourceSize;
    protected PushService<?, ?> pushService;
    protected Javalin service;
    protected int port;
    private boolean started = false;
    protected static final String WebDirectory = "/www";
    protected static final long MaxResourceSize = 0x6400000L;

    public AlexandriaHttpServer(int port) {
        this(port, WebDirectory);
    }

    public AlexandriaHttpServer(int port, String webDirectory) {
        this(port, webDirectory, 0x6400000L);
    }

    public AlexandriaHttpServer(int port, String webDirectory, long maxResourceSize) {
        this.port = port;
        this.webDirectories.add(webDirectory);
        this.maxResourceSize = maxResourceSize;
    }

    public Javalin service() {
        return this.service;
    }

    public AlexandriaHttpServer<?> start() {
        if (this.started) {
            return this;
        }
        this.init();
        this.service.start(this.port);
        this.started = true;
        return this;
    }

    public int activeThreadCount() {
        return this.service.jettyServer().threadPool().getThreads();
    }

    public void stop() {
        if (this.service != null) {
            this.service.stop();
        }
        this.service = null;
    }

    public String webDirectory() {
        return this.webDirectories.isEmpty() ? null : this.webDirectories.get(0);
    }

    public void add(String webDirectory) {
        this.webDirectories.add(webDirectory);
    }

    public void secure(AlexandriaSecurityManager manager) {
        this.securityManager = manager;
    }

    public R route(String path) {
        this.init();
        R router = this.createRouter(path);
        router.push(this.pushService);
        router.whenRegisterPushService(this.pushServiceConsumer());
        router.whenValidate(manager -> this.securityManager.check(manager.fromQuery("hash"), manager.fromQuery("signature")));
        return router;
    }

    public <T extends Exception> void handle(Class<T> exceptionClass, ExceptionHandler<? super T> handler) {
        this.init();
        this.service.exception(exceptionClass, handler);
    }

    protected R createRouter(String path) {
        this.init();
        return (R)new JavalinHttpRouter(this.service, path, this.webDirectories);
    }

    protected void init() {
        if (this.service != null) {
            return;
        }
        this.service = AlexandriaHttpServer.create(this.webDirectories, this.maxResourceSize);
    }

    private Consumer<PushService<?, ?>> pushServiceConsumer() {
        return pushService -> {
            this.pushService = pushService;
        };
    }

    private static Javalin create(final List<String> webDirectories, long maxResourceSize) {
        Javalin result = Javalin.create(config -> {
            AlexandriaHttpServer.register(webDirectories, config);
            final ResourceHandler defaultHandler = config.pvt.resourceHandler;
            config.pvt.resourceHandler = new ResourceHandler(){

                public boolean canHandle(Context context) {
                    return defaultHandler != null && defaultHandler.canHandle(context);
                }

                public boolean handle(Context context) {
                    InputStream inputStream = AlexandriaHttpServer.locate(context, webDirectories);
                    if (inputStream != null) {
                        String contentType = MimeTypes.getFromFilename(context.path());
                        context.result(inputStream);
                        if (contentType != null) {
                            context.contentType(contentType);
                        }
                        return true;
                    }
                    return defaultHandler != null && defaultHandler.handle(context);
                }

                public boolean addStaticFileConfig(StaticFileConfig config) {
                    return defaultHandler != null && defaultHandler.addStaticFileConfig(config);
                }
            };
        });
        result.before(ctx -> {
            MultipartConfigElement multipartConfig = new MultipartConfigElement("", maxResourceSize, -1L, -1);
            ctx.req().setAttribute("org.eclipse.jetty.multipartConfig", (Object)multipartConfig);
        });
        result.exception(Exception.class, (exception, context) -> Logger.error((Throwable)exception));
        return result;
    }

    private static void register(List<String> webDirectories, JavalinConfig config) {
        webDirectories.forEach(wd -> AlexandriaHttpServer.register(wd, config));
    }

    private static void register(String webDirectory, JavalinConfig config) {
        if (AlexandriaHttpServer.isInClasspath(webDirectory)) {
            config.staticFiles.add(webDirectory, Location.CLASSPATH);
        } else {
            config.staticFiles.add(webDirectory, Location.EXTERNAL);
        }
    }

    private static InputStream locate(Context context, List<String> webDirectories) {
        String filePath = context.path();
        for (String webDirectory : webDirectories) {
            String dir = webDirectory.endsWith("/") ? webDirectory.substring(0, webDirectory.length() - 1) : webDirectory;
            InputStream result = AlexandriaHttpServer.class.getClassLoader().getResourceAsStream(dir + filePath);
            if (result == null) {
                result = AlexandriaHttpServer.localFileStream(dir, filePath);
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static InputStream localFileStream(String webDirectory, String filePath) {
        try {
            File file = new File(webDirectory, filePath);
            if (!file.exists()) {
                file = new File(webDirectory, filePath.replace("/_alexandria-displays", ""));
            }
            return file.exists() ? file.toURI().toURL().openStream() : null;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private static void addDevEnvironment(StaticFilesConfig staticFiles) {
        try {
            File file = new File(AlexandriaHttpServer.class.getClassLoader().getResource("").toURI().toURL().getFile(), "..");
            if (!file.exists()) {
                return;
            }
            staticFiles.add(file.getAbsolutePath(), Location.EXTERNAL);
        }
        catch (MalformedURLException | URISyntaxException exception) {
            // empty catch block
        }
    }

    private static boolean isInClasspath(String path) {
        if (path == null) {
            return false;
        }
        return AlexandriaHttpServer.class.getClassLoader().getResourceAsStream(path) != null;
    }

    public static interface ResourceCaller<SM extends AlexandriaHttpManager<?>> {
        public void call(SM var1) throws AlexandriaException, ServletException, IOException;
    }
}

