/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http.spark;

import io.intino.alexandria.http.spark.PushService;
import io.intino.alexandria.http.spark.SparkClient;
import io.intino.alexandria.logger.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.common.WebSocketSession;

@WebSocket(maxTextMessageSize=0x500000)
public class PushServiceHandler {
    private static PushService pushService;
    private Map<String, List<SparkClient>> clientsMap = new HashMap<String, List<SparkClient>>();
    private Map<String, Timer> closeTimersMap = new HashMap<String, Timer>();
    private static final int CloseTimeout = 86400000;
    private static final int CloseGoingAway = 1001;
    private static final int CloseReadEOF = 1006;

    public static void inject(io.intino.alexandria.http.pushservice.PushService pushService) {
        PushServiceHandler.pushService = (PushService)pushService;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) throws Exception {
        SparkClient client = this.client(session);
        if (client != null) {
            this.cancelClose(session);
            this.client(session).session(session);
        } else {
            this.registerClient(session);
        }
        pushService.onOpen(this.client(session));
    }

    @OnWebSocketError
    public void onError(Session session, Throwable error) {
        String sessionId = SparkClient.sessionId(session);
        try {
            if (this.closeTimersMap.containsKey(sessionId)) {
                this.closeTimersMap.get(sessionId).cancel();
                this.closeTimersMap.remove(sessionId);
            }
        }
        catch (Throwable ex) {
            Logger.error((Throwable)ex);
        }
        if (error.getMessage() != null) {
            Logger.debug((String)error.getMessage());
        } else {
            Logger.debug((String)error.toString());
        }
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        String sessionId = SparkClient.sessionId(session);
        this.cancelClose(session);
        if (statusCode == 1001) {
            Logger.debug((String)String.format("WebSocket connection lost. Status code: %d. %s", statusCode, reason));
            this.doClose(sessionId, this.client(session));
            return;
        }
        this.doCloseDelayed(session, sessionId);
    }

    @OnWebSocketMessage
    public void onMessage(Session session, String message) {
        SparkClient client = this.client(session);
        if (client == null) {
            try {
                session.disconnect();
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
        pushService.onMessage(this.client(session), message);
    }

    protected SparkClient client(Session session) {
        String sessionId = this.id(session);
        if (!this.clientsMap.containsKey(sessionId)) {
            return null;
        }
        String clientId = this.clientId(session);
        return this.clientsMap.get(sessionId).stream().filter(c -> c.id().equals(clientId)).findFirst().orElse(null);
    }

    protected SparkClient registerClient(Session session) {
        String sessionId = this.id(session);
        SparkClient client = (SparkClient)pushService.createClient(session);
        if (!this.clientsMap.containsKey(sessionId)) {
            this.clientsMap.put(sessionId, new ArrayList());
        }
        this.clientsMap.get(sessionId).add(client);
        return client;
    }

    private String id(Session session) {
        return SparkClient.sessionId(session);
    }

    private void cancelClose(Session session) {
        String sessionId = this.id(session);
        if (!this.closeTimersMap.containsKey(sessionId)) {
            return;
        }
        this.closeTimersMap.get(sessionId).cancel();
        this.closeTimersMap.remove(sessionId);
    }

    private void doCloseDelayed(Session session, final String sessionId) {
        final SparkClient client = this.client(session);
        if (client != null) {
            pushService.onCloseScheduled(client);
        }
        Timer timer = new Timer("Push service delayed close");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PushServiceHandler.this.doClose(sessionId, client);
            }
        }, 86400000L);
        this.closeTimersMap.put(sessionId, timer);
    }

    private void doClose(String sessionId, SparkClient client) {
        if (client != null) {
            pushService.onClose(client);
        }
        this.removeClientFromClientsMap(sessionId, client);
        if (!this.closeTimersMap.containsKey(sessionId)) {
            return;
        }
        this.closeTimersMap.get(sessionId).cancel();
        this.closeTimersMap.remove(sessionId);
    }

    private void removeClientFromClientsMap(String sessionId, SparkClient client) {
        SparkClient savedClient;
        if (!this.clientsMap.containsKey(sessionId)) {
            return;
        }
        List<SparkClient> clientList = this.clientsMap.get(sessionId);
        SparkClient sparkClient = savedClient = client != null ? (SparkClient)clientList.stream().filter(c -> c.id().equals(client.id())).findFirst().orElse(null) : null;
        if (savedClient != null) {
            this.clientsMap.get(sessionId).remove(savedClient);
        }
        if (this.clientsMap.get(sessionId).size() <= 0) {
            this.clientsMap.remove(sessionId);
        }
    }

    private void refreshSession(Session session) {
        SparkClient client = this.registerClient(session);
        client.session(session);
        pushService.linkToThread(client);
    }

    private String clientId(Session session) {
        String[] params = ((WebSocketSession)session).getRequestURI().getQuery().split("&");
        if (params.length <= 0) {
            return null;
        }
        String[] split = params[0].split("=");
        return split.length > 1 ? split[1] : null;
    }
}

