/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http;

import io.intino.alexandria.http.AlexandriaSpark;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class AlexandriaSparkBuilder {
    private static AlexandriaSpark instance;
    private static int port;
    private static String webDirectory;
    private static boolean ui;
    private static List<Object> objects;

    public static void setup(int port, String webDirectory) {
        AlexandriaSparkBuilder.port = port;
        AlexandriaSparkBuilder.webDirectory = webDirectory;
    }

    public static boolean isUI() {
        return ui;
    }

    public static void setUI(boolean value) {
        ui = value;
    }

    public static AlexandriaSpark instance() {
        return instance == null ? (instance = AlexandriaSparkBuilder.getInstance()) : instance;
    }

    public static void addParameters(Object ... objs) {
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            objects.add(objs[i]);
        }
    }

    private static AlexandriaSpark getInstance() {
        return ui ? AlexandriaSparkBuilder.loadUISpark() : new AlexandriaSpark(port, webDirectory);
    }

    private static AlexandriaSpark loadUISpark() {
        try {
            Class<?> aClass = Class.forName("io.intino.alexandria.ui.UISpark");
            Constructor<?> constructor = aClass.getConstructors()[0].getParameterCount() == 3 ? aClass.getConstructors()[0] : aClass.getConstructors()[1];
            return (AlexandriaSpark)constructor.newInstance(port, webDirectory, objects.size() > 0 ? objects.get(0) : null);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LoggerFactory.getLogger((String)"ROOT").error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static {
        ui = false;
        objects = new ArrayList<Object>();
    }
}

