/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http.spark;

import io.intino.alexandria.Resource;
import io.intino.alexandria.http.spark.PushService;
import io.intino.alexandria.http.spark.SparkSession;
import io.intino.alexandria.http.spark.SparkWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import spark.Request;
import spark.Response;

public class SparkManager<P extends PushService> {
    private static final String XForwardedProto = "X-Forwarded-Proto";
    private static final String XForwardedPath = "X-Forwarded-Path";
    private static final String XForwardedPort = "X-Forwarded-Port";
    protected final P pushService;
    protected final Request request;
    protected final Response response;

    public SparkManager(P pushService, Request request, Response response) {
        this.pushService = pushService;
        this.request = request;
        this.response = response;
        this.setUpMultipartConfiguration();
        this.setUpSessionCookiePath();
    }

    public P pushService() {
        return this.pushService;
    }

    public SparkSession currentSession() {
        String sessionId = this.request.cookie(this.sessionCookieName());
        if (sessionId == null) {
            sessionId = this.request.session().id();
        }
        return (SparkSession)((PushService)this.pushService).session(sessionId);
    }

    public void write(Object object) {
        new SparkWriter(this.response).write(object);
    }

    public void writeHeader(String name, String value) {
        new SparkWriter(this.response).writeHeader(name, value);
    }

    public void write(Object object, String name) {
        this.write(object, name, false);
    }

    public void write(Object object, String name, boolean embedded) {
        new SparkWriter(this.response).write(object, name, embedded);
    }

    public String fromHeader(String name) {
        return this.request.headers(name);
    }

    public String fromHeaderOrDefault(String name, String defaultValue) {
        return this.request.headers(name) == null ? defaultValue : this.request.headers(name);
    }

    public <X extends Throwable> String fromHeaderOrElseThrow(String name, Supplier<? extends X> exceptionSupplier) throws X {
        if (this.request.headers(name) == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.request.headers(name);
    }

    public String fromQuery(String name) {
        return this.request.queryParams(name);
    }

    public String fromQueryOrDefault(String name, String defaultValue) {
        return this.request.queryParams(name) == null ? defaultValue : this.request.queryParams(name);
    }

    public <X extends Throwable> String fromQueryOrElseThrow(String name, Supplier<? extends X> exceptionSupplier) throws X {
        if (this.request.queryParams(name) == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.request.queryParams(name);
    }

    public Map<String, String[]> formAndQueryParameters() {
        return this.request.raw().getParameterMap();
    }

    public String fromPath(String name) {
        return this.request.params(name);
    }

    public String fromPathOrDefault(String name, String defaultValue) {
        return this.request.params(name) == null ? defaultValue : this.request.params(name);
    }

    public <X extends Throwable> String fromPathOrElseThrow(String name, Supplier<? extends X> exceptionSupplier) throws X {
        if (this.request.params(name) == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.request.params(name);
    }

    @Deprecated
    public String body(String value) {
        return this.request.body();
    }

    public String body() {
        return this.request.body();
    }

    public byte[] fromBodyAsBytes() {
        return this.request.bodyAsBytes();
    }

    public String fromBody() {
        return this.request.body();
    }

    public <X extends Throwable> String fromBodyOrElseThrow(String name, Supplier<? extends X> exceptionSupplier) throws X {
        String body = this.request.body();
        if (body == null || body.isEmpty()) {
            throw (Throwable)exceptionSupplier.get();
        }
        return body;
    }

    public Resource fromFormAsResource(String name) {
        return this.fromPartAsResource(name);
    }

    public Resource fromFormAsResourceOrDefault(String name, Resource defaultValue) {
        Resource resource = this.fromPartAsResource(name);
        return resource != null ? resource : defaultValue;
    }

    public <X extends Throwable> Resource fromFormAsResourceOrElseThrow(String name, Supplier<? extends X> exceptionSupplier) throws X {
        Resource resource = this.fromPartAsResource(name);
        if (resource == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return resource;
    }

    public String fromFormAsString(String name) {
        return this.fromPartAsString(name);
    }

    public String fromFormAsStringOrDefault(String name, String defaultValue) {
        String content = this.fromPartAsString(name);
        return content != null ? content : defaultValue;
    }

    public <X extends Throwable> String fromFormAsStringOrElseThrow(String name, Supplier<? extends X> exceptionSupplier) throws X {
        String resource = this.fromPartAsString(name);
        if (resource == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return resource;
    }

    public List<Resource> fromPartsAsResources() {
        try {
            return this.request.raw().getParts().stream().filter(p -> !this.textContentType((Part)p)).map(p -> this.fromPartAsResource(p.getName())).collect(Collectors.toList());
        }
        catch (IOException | ServletException e) {
            return Collections.emptyList();
        }
    }

    public List<String> fromPartsAsStrings() {
        try {
            return this.request.raw().getParts().stream().filter(this::textContentType).map(p -> this.fromPartAsString(p.getName())).collect(Collectors.toList());
        }
        catch (IOException | ServletException e) {
            return Collections.emptyList();
        }
    }

    private Resource fromPartAsResource(String name) {
        try {
            Part part = this.request.raw().getPart(name);
            return part != null ? new Resource(part.getSubmittedFileName() == null ? part.getName() : part.getSubmittedFileName(), part.getInputStream()).metadata().contentType(part.getContentType()) : null;
        }
        catch (IOException | ServletException e) {
            return null;
        }
    }

    private String fromPartAsString(String name) {
        try {
            Part part = this.request.raw().getPart(name);
            return part != null ? new String(part.getInputStream().readAllBytes(), StandardCharsets.UTF_8) : null;
        }
        catch (IOException | ServletException e) {
            return null;
        }
    }

    public Request request() {
        return this.request;
    }

    public Response response() {
        return this.response;
    }

    public String domain() {
        try {
            URL url = new URL(this.request.raw().getRequestURL().toString());
            Object result = url.getHost();
            int port = this.getHeaderPort();
            if (port == -1) {
                port = url.getPort();
            }
            if (port != 80 && port != -1) {
                result = (String)result + ":" + port;
            }
            return result;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String baseUrl() {
        String result = this.generateBaseUrl();
        result = this.addHeaderProtocol(result);
        result = this.addHeaderPath(result);
        return result;
    }

    public String basePath() {
        String forwardedPath = this.request.raw().getHeader(XForwardedPath);
        return forwardedPath == null || forwardedPath.equals("") || forwardedPath.equals("/") ? "" : forwardedPath;
    }

    public String getHeader(String name) {
        return this.request.raw().getHeader(name);
    }

    public String ip() {
        return this.request.ip();
    }

    public String realIp() {
        HttpServletRequest raw = this.request.raw();
        String ip = raw.getHeader("X-Real-IP");
        if (ip == null || ip.isEmpty()) {
            ip = raw.getHeader("X-Forwarded-For");
        }
        if (ip != null && !ip.isEmpty()) {
            int indexComma = ip.indexOf(44);
            if (indexComma == -1) {
                return ip;
            }
            return ip.substring(0, indexComma);
        }
        return raw.getRemoteAddr();
    }

    private boolean textContentType(Part p) {
        return "application/json".equals(p.getContentType()) || "text/plain".equals(p.getContentType());
    }

    private void setUpMultipartConfiguration() {
        MultipartConfigElement multipartConfigElement = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));
        this.request.raw().setAttribute("org.eclipse.jetty.multipartConfig", (Object)multipartConfigElement);
    }

    private void setUpSessionCookiePath() {
        HttpServletRequest request = this.request.raw();
        HttpSession session = request.getSession();
        String sessionCookieName = this.sessionCookieName();
        if (request.getParameter(sessionCookieName) != null) {
            Cookie userCookie = new Cookie(sessionCookieName, request.getParameter(sessionCookieName));
            userCookie.setHttpOnly(true);
            userCookie.setSecure(true);
            this.response.raw().addCookie(userCookie);
        } else if (this.request.cookie(sessionCookieName) == null) {
            String sessionId = session.getId();
            Cookie userCookie = new Cookie(sessionCookieName, sessionId);
            userCookie.setHttpOnly(true);
            userCookie.setSecure(true);
            this.response.raw().addCookie(userCookie);
        }
    }

    private String sessionCookieName() {
        String sessionCookieName;
        String header = this.request.raw().getHeader(XForwardedPath);
        String string = sessionCookieName = header != null ? header.replace("/", "") : "federacion";
        if (sessionCookieName.isEmpty()) {
            sessionCookieName = "federacion";
        }
        return sessionCookieName;
    }

    private String generateBaseUrl() {
        try {
            URL url = new URL(this.request.raw().getRequestURL().toString());
            String baseUrl = url.getProtocol() + "://" + url.getHost();
            int port = this.getHeaderPort();
            if (port == -1) {
                port = url.getPort();
            }
            if (port != 80 && port != -1) {
                baseUrl = baseUrl + ":" + port;
            }
            return baseUrl;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private String addHeaderProtocol(String url) {
        String forwardedProto = this.request.raw().getHeader(XForwardedProto);
        if (forwardedProto == null || !forwardedProto.equals("https")) {
            return url;
        }
        return url.replace("http:", "https:");
    }

    private String addHeaderPath(String url) {
        String forwardedPath = this.request.raw().getHeader(XForwardedPath);
        if (forwardedPath == null) {
            return url;
        }
        return url + (forwardedPath.equals("") || forwardedPath.equals("/") ? "" : forwardedPath);
    }

    private int getHeaderPort() {
        String forwardedPort = this.request.raw().getHeader(XForwardedPort);
        if (forwardedPort == null || forwardedPort.isEmpty()) {
            return -1;
        }
        return Integer.valueOf(forwardedPort);
    }

    public void redirect(String location) {
        this.response.redirect(location);
    }
}

