/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http.security;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import spark.utils.IOUtils;

public class CertificateVerifier {
    public static String getOriginalContentFromSignature(byte[] signedBytes) throws Exception {
        CMSSignedData s = new CMSSignedData(signedBytes);
        CMSProcessable signedContent = s.getSignedContent();
        return new String((byte[])signedContent.getContent());
    }

    public static boolean checkRootCertificate(byte[] signature, File storeFile, TYPE_PKCS typePKCSFile, String password) {
        try {
            KeyStore keyStore;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            byte[] storeBytes = CertificateVerifier.storeBytes(storeFile);
            ByteArrayInputStream signatureIn = new ByteArrayInputStream(signature);
            DERObject obj = new ASN1InputStream((InputStream)signatureIn).readObject();
            ContentInfo contentInfo = ContentInfo.getInstance((Object)obj);
            SignedData signedData = SignedData.getInstance((Object)contentInfo.getContent());
            Enumeration certificates = signedData.getCertificates().getObjects();
            ArrayList<Certificate> certList = new ArrayList<Certificate>();
            while (certificates.hasMoreElements()) {
                DERObject certObj = (DERObject)certificates.nextElement();
                ByteArrayInputStream in = new ByteArrayInputStream(certObj.getDEREncoded());
                certList.add(cf.generateCertificate(in));
            }
            CertPath certPath = cf.generateCertPath(certList);
            if (typePKCSFile == TYPE_PKCS.PKCS7) {
                Collection<? extends Certificate> col = cf.generateCertificates(new ByteArrayInputStream(storeBytes));
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                for (Certificate certificate : col) {
                    X509Certificate cert = (X509Certificate)certificate;
                    keyStore.setCertificateEntry(cert.getSerialNumber().toString(36), cert);
                }
            } else {
                keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(new ByteArrayInputStream(storeBytes), null);
            }
            PKIXParameters params = new PKIXParameters(keyStore);
            params.setRevocationEnabled(false);
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            validator.validate(certPath, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public KeyPair create() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        keyGen.initialize(1024, random);
        return keyGen.generateKeyPair();
    }

    public void save(Key key, File destiny) {
        try {
            FileOutputStream outputStream = new FileOutputStream(destiny);
            outputStream.write(key.getEncoded());
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void store(KeyPair pair) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] privateKeyBytes = pair.getPrivate().getEncoded();
        byte[] publicKeyBytes = pair.getPublic().getEncoded();
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyBytes);
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
    }

    private static byte[] storeBytes(File storeFile) throws IOException {
        return IOUtils.toByteArray((InputStream)new FileInputStream(storeFile));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static enum TYPE_PKCS {
        PKCS7,
        PKCS12;

    }
}

