/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http.spark;

import io.intino.alexandria.http.pushservice.Client;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WriteCallback;

public class SparkClient
implements Client {
    private Session session;
    private final Map<String, String> queryString;
    private String language = null;
    private List<String> messagesQueue = new ArrayList<String>();
    private Timer queueTimer;

    public SparkClient(Session session) {
        this.session = session;
        this.queryString = SparkClient.parseQueryString(session.getUpgradeRequest().getRequestURI().getQuery());
        this.runQueueManager();
    }

    public Session session() {
        return this.session;
    }

    public SparkClient session(Session session) {
        this.session = session;
        return this;
    }

    public static String sessionId(Session session) {
        Map<String, String> queryString = SparkClient.parseQueryString(session.getUpgradeRequest().getRequestURI().getQuery());
        return queryString.get("currentSession");
    }

    @Override
    public String id() {
        return this.queryString.get("id");
    }

    @Override
    public String sessionId() {
        return SparkClient.sessionId(this.session);
    }

    @Override
    public String language() {
        return this.language != null ? this.language : this.queryString.get("language");
    }

    @Override
    public void language(String language) {
        this.language = language;
    }

    @Override
    public void send(final String message) {
        if (!this.session.isOpen()) {
            return;
        }
        this.session.getRemote().sendString(message, new WriteCallback(){

            public void writeFailed(Throwable throwable) {
                if (!SparkClient.this.messagesQueue.contains(message)) {
                    SparkClient.this.messagesQueue.add(message);
                }
            }

            public void writeSuccess() {
                if (SparkClient.this.messagesQueue.contains(message)) {
                    SparkClient.this.messagesQueue.remove(message);
                }
            }
        });
    }

    @Override
    public void destroy() {
        this.queueTimer.cancel();
        this.messagesQueue.clear();
    }

    public int hashCode() {
        return this.sessionId().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof SparkClient && this.id().equals(((SparkClient)obj).id());
    }

    private static Map<String, String> parseQueryString(String queryString) {
        return Stream.of(queryString.split("&")).map(param -> param.split("=")).collect(Collectors.toMap(p -> p[0], p -> p[1]));
    }

    private void runQueueManager() {
        this.queueTimer = new Timer("spark queue timer");
        this.queueTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!SparkClient.this.session.isOpen()) {
                    SparkClient.this.messagesQueue.clear();
                }
                SparkClient.this.messagesQueue.forEach(message -> SparkClient.this.send((String)message));
            }
        }, 1000L, 1000L);
    }
}

