/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.fsm;

import io.intino.alexandria.fsm.SessionMessageFile;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

class ZipUtils {
    ZipUtils() {
    }

    public static void createNewZipFile(File zipFile, List<SessionMessageFile> files) {
        try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(zipFile));){
            for (SessionMessageFile file : files) {
                InputStream inputStream = Files.newInputStream(file.file().toPath(), new OpenOption[0]);
                try {
                    ZipUtils.zipFile(zip, file.getName(), inputStream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public static void addNewEntriesToExistingZipFile(File zipFile, List<SessionMessageFile> files) {
        File tempZipFile = new File(zipFile.getAbsolutePath() + ".temp");
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFile));
             ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(tempZipFile));){
            ZipEntry entry;
            while ((entry = zipIn.getNextEntry()) != null) {
                ZipUtils.zipFile(zipOut, entry.getName(), zipIn);
            }
            for (SessionMessageFile file : files) {
                InputStream inputStream = Files.newInputStream(file.file().toPath(), new OpenOption[0]);
                try {
                    ZipUtils.zipFile(zipOut, file.getName(), inputStream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        try {
            Files.move(tempZipFile.toPath(), zipFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private static void zipFile(ZipOutputStream zip, String entryName, InputStream inputStream) throws IOException {
        int read;
        zip.putNextEntry(new ZipEntry(entryName));
        byte[] buffer = new byte[1024];
        while ((read = inputStream.read(buffer)) > 0) {
            zip.write(buffer, 0, read);
        }
    }
}

