/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.fsm;

import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class TimePeriod {
    private final long amount;
    private final TimeUnit timeUnit;

    public TimePeriod(long amount, TimeUnit timeUnit) {
        this.amount = this.requirePositive(amount);
        this.timeUnit = Objects.requireNonNull(timeUnit);
    }

    public long amount() {
        return this.amount;
    }

    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    public TemporalUnit temporalUnit() {
        return ChronoUnit.valueOf(this.timeUnit.name());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimePeriod that = (TimePeriod)o;
        return this.amount == that.amount && this.timeUnit == that.timeUnit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.timeUnit});
    }

    public String toString() {
        return this.amount + " " + this.timeUnit.name().toLowerCase();
    }

    private long requirePositive(long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException("Period amount must be > 0");
        }
        return period;
    }
}

