/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.fsm;

import io.intino.alexandria.fsm.TimePeriod;
import io.intino.alexandria.logger.Logger;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class StatefulScheduledService {
    private final TimePeriod period;
    private final ScheduledExecutorService executor;
    private final AtomicReference<State> state;
    private ScheduledFuture<?> execution;

    public StatefulScheduledService(TimePeriod period) {
        this.period = Objects.requireNonNull(period);
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.state = new AtomicReference<State>(State.Created);
    }

    public synchronized boolean start(Task task) {
        if (task == null) {
            throw new NullPointerException("Task cannot be null");
        }
        if (!this.state.compareAndSet(State.Created, State.Running)) {
            return false;
        }
        this.execution = this.executor.scheduleWithFixedDelay(this.execute(task), 0L, this.period.amount(), this.period.timeUnit());
        return true;
    }

    private Runnable execute(Task task) {
        return () -> {
            try {
                if (this.state.get().equals((Object)State.Running)) {
                    task.onUpdate();
                }
                task.onFinally();
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        };
    }

    public boolean pause() {
        return this.state.compareAndSet(State.Running, State.Paused);
    }

    public boolean resume() {
        return this.state.compareAndSet(State.Paused, State.Running);
    }

    public synchronized void stop(long timeout, TimeUnit timeUnit) {
        if (this.state.get() == State.Terminated || this.state.get() == State.Cancelled) {
            return;
        }
        this.state.set(State.Terminated);
        this.executor.shutdown();
        this.waitFor(timeout, timeUnit);
    }

    public synchronized void cancel() {
        if (this.execution == null) {
            return;
        }
        if (this.state.get() == State.Cancelled || this.state.get() == State.Terminated) {
            return;
        }
        this.state.set(State.Cancelled);
        this.execution.cancel(true);
        this.executor.shutdownNow();
        this.waitFor(1L, TimeUnit.SECONDS);
    }

    private void waitFor(long timeout, TimeUnit timeUnit) {
        try {
            this.executor.awaitTermination(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Logger.error((Throwable)e);
        }
    }

    public ScheduledFuture<?> execution() {
        return this.execution;
    }

    public State state() {
        return this.state.get();
    }

    public TimePeriod period() {
        return this.period;
    }

    static abstract class Task {
        Task() {
        }

        abstract void onUpdate();

        void onPaused() {
        }

        void onFinally() {
        }
    }

    public static enum State {
        Created,
        Running,
        Paused,
        Cancelled,
        Terminated;

    }
}

