/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.fsm;

import io.intino.alexandria.fsm.FileSessionManager;
import io.intino.alexandria.fsm.IndexFile;
import io.intino.alexandria.fsm.SessionMessageFile;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class SessionMessagePipeline {
    public final void execute(SessionMessageFile messageFile, FileSessionManager fsm, Stage ... stages) {
        if (messageFile == null) {
            throw new NullPointerException("messageFile is null");
        }
        if (fsm == null) {
            throw new NullPointerException("manager is null");
        }
        EnumSet<Stage> stagesToExecute = this.isNullOrEmpty(stages) ? EnumSet.allOf(Stage.class) : Arrays.stream(stages).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
        this.execute(messageFile, fsm, stagesToExecute);
    }

    protected void execute(SessionMessageFile messageFile, FileSessionManager fsm, Set<Stage> stages) {
        try {
            Operation operation;
            if (stages.contains((Object)Stage.OnPending) && ((operation = this.onPending(messageFile, fsm)) == null || operation == Operation.Stop)) {
                return;
            }
            if (stages.contains((Object)Stage.OnProcessing) && ((operation = this.onProcessing(messageFile, fsm)) == null || operation == Operation.Stop)) {
                return;
            }
            if (stages.contains((Object)Stage.OnProcessed)) {
                this.onProcessed(messageFile, fsm);
            }
        }
        catch (Throwable e) {
            this.onPipelineError(e, messageFile, fsm);
        }
    }

    protected Operation onPending(SessionMessageFile messageFile, FileSessionManager fsm) {
        messageFile.moveTo(fsm.inputMailbox().processing());
        return Operation.Continue;
    }

    protected Operation onProcessing(SessionMessageFile messageFile, FileSessionManager fsm) throws Exception {
        this.processSessionMessageFile(messageFile, fsm);
        return Operation.Continue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessionMessageFile(SessionMessageFile messageFile, FileSessionManager fsm) throws Exception {
        Iterator<String> messageIterator = messageFile.iterator();
        IndexFile indexFile = fsm.createIndexFile(messageFile);
        try {
            this.skipMessagesBeforeIndex(messageIterator, indexFile.index());
            while (messageIterator.hasNext()) {
                String message = messageIterator.next();
                try {
                    this.processMessage(message, fsm);
                }
                catch (Throwable e) {
                    this.onMessageError(message, fsm);
                }
                indexFile.increment();
            }
            indexFile.close();
        }
        finally {
            if (indexFile != null) {
                indexFile.save();
            }
        }
    }

    protected abstract void processMessage(String var1, FileSessionManager var2) throws Throwable;

    protected void onMessageError(String message, FileSessionManager fsm) {
        try {
            File file = fsm.inputMailbox().currentErrorFile();
            file.getParentFile().mkdirs();
            Files.writeString(file.toPath(), (CharSequence)(message + "\n"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
        }
    }

    protected void onProcessed(SessionMessageFile messageFile, FileSessionManager fsm) {
        messageFile.moveTo(fsm.inputMailbox().processed());
    }

    protected void onPipelineError(Throwable e, SessionMessageFile messageFile, FileSessionManager fsm) {
        Logger.error((Throwable)e);
    }

    private boolean isNullOrEmpty(Stage[] stages) {
        return stages == null || stages.length == 0;
    }

    private void skipMessagesBeforeIndex(Iterator<String> messageIterator, long toExclusive) {
        for (long index = 0L; index < toExclusive && messageIterator.hasNext(); ++index) {
            messageIterator.next();
        }
    }

    public static enum Stage {
        OnPending,
        OnProcessing,
        OnProcessed;

    }

    public static enum Operation {
        Continue,
        Stop;

    }
}

