/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.fsm;

import io.intino.alexandria.fsm.SessionHelper;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SessionMessageFile
implements Iterable<String> {
    private File file;

    public SessionMessageFile(File file) {
        this.file = Objects.requireNonNull(file);
    }

    public String getName() {
        return this.file.getName();
    }

    public File file() {
        return this.file;
    }

    public void delete() {
        this.file.delete();
    }

    public Stream<String> messages() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public List<String> messageList() {
        return this.messages().collect(Collectors.toList());
    }

    @Override
    public Iterator<String> iterator() {
        return new SessionMessageFileIterator();
    }

    public boolean moveTo(File directory) {
        return this.moveTo(directory, "");
    }

    public boolean moveTo(File directory, String prefix) {
        try {
            directory.mkdirs();
            File dst = new File(directory, prefix + this.file.getName());
            Files.move(this.file.toPath(), dst.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            this.file = dst;
            return true;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionMessageFile strings = (SessionMessageFile)o;
        return Objects.equals(this.file, strings.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public String toString() {
        return this.file.toString() + " (size=" + this.kbSize() + ")";
    }

    private String kbSize() {
        return String.format("%.2f KB", Float.valueOf((float)this.file.length() / 1024.0f));
    }

    public LocalDateTime dateTime() {
        return SessionHelper.dateTimeOf(this.file);
    }

    private class SessionMessageFileIterator
    implements Iterator<String> {
        private final Iterator<String> iterator;

        public SessionMessageFileIterator() {
            Iterator iterator;
            try {
                iterator = Files.lines(SessionMessageFile.this.file.toPath()).iterator();
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                iterator = Stream.empty().iterator();
            }
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            return this.iterator.next();
        }
    }
}

