/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.fsm;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class SessionHelper {
    private static final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss_SS");

    public static File newTempSessionFile(File pendingDir, LocalDateTime ts, String name) {
        return new File(pendingDir, SessionHelper.format(ts) + "." + name + ".session.temp");
    }

    public static LocalDateTime dateTimeOf(File sessionFile) {
        try {
            String name = sessionFile.getName();
            String ts = name.substring(0, name.indexOf(46));
            return LocalDateTime.parse(ts, Formatter);
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private static String format(LocalDateTime ts) {
        return Formatter.format(ts);
    }
}

