/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.fsm;

import io.intino.alexandria.logger.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.Semaphore;

public class Session
implements AutoCloseable {
    private final File file;
    private volatile BufferedOutputStream writer;
    private volatile int byteCount;
    private volatile Instant lastWriting;
    private final Semaphore semaphore = new Semaphore(1);

    public Session(File file) throws IOException {
        this(file, true);
    }

    public Session(File file, boolean append) throws IOException {
        this.file = file;
        this.writer = new BufferedOutputStream(new FileOutputStream(file, append));
    }

    boolean write(String message) {
        return this.write(message.concat("\n").getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean write(byte[] bytes) {
        try {
            this.semaphore.acquire();
            if (this.isClosed()) {
                boolean bl = false;
                return bl;
            }
            this.writer.write(bytes);
            this.byteCount += bytes.length;
            this.lastWriting = Instant.now();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.semaphore.release();
        }
    }

    public int byteCount() {
        return this.byteCount;
    }

    public Instant lastWriting() {
        return this.lastWriting;
    }

    public boolean isClosed() {
        return this.writer == null;
    }

    @Override
    public synchronized void close() {
        try {
            this.semaphore.acquire();
            if (this.writer == null) {
                return;
            }
            this.writer.close();
            this.writer = null;
        }
        catch (Exception e) {
            Logger.error((String)("Error while closing session: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.semaphore.release();
        }
    }

    public File file() {
        return this.file;
    }
}

