/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.fsm;

import io.intino.alexandria.fsm.SessionMessageFile;
import java.io.File;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Mailbox {
    public static final String PENDING_DIR_NAME = "00_pending";
    public static final String PROCESSING_DIR_NAME = "01_processing";
    public static final String PROCESSED_DIR_NAME = "02_processed";
    public static final String ERRORS_DIR_NAME = "03_errors";
    private final File root;
    private final File pending;
    private final File processing;
    private final File processed;
    private final File error;
    private static final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("yyyyMMdd");

    public Mailbox(File root) {
        this.root = Objects.requireNonNull(root);
        this.pending = new File(root, PENDING_DIR_NAME);
        this.processing = new File(root, PROCESSING_DIR_NAME);
        this.processed = new File(root, PROCESSED_DIR_NAME);
        this.error = new File(root, ERRORS_DIR_NAME);
        this.mkdirs();
    }

    public File root() {
        return this.root;
    }

    public File pending() {
        return this.pending;
    }

    public List<SessionMessageFile> listPendingMessages() {
        return this.listFiles(this.pending, ".session").map(SessionMessageFile::new).collect(Collectors.toList());
    }

    public File processing() {
        return this.processing;
    }

    public List<SessionMessageFile> listProcessingMessages() {
        return this.listFiles(this.processing, ".session").map(SessionMessageFile::new).collect(Collectors.toList());
    }

    public File processed() {
        return this.processed;
    }

    public List<SessionMessageFile> listProcessedMessages() {
        return this.listFiles(this.processed, ".session").map(SessionMessageFile::new).collect(Collectors.toList());
    }

    public File errors() {
        return this.error;
    }

    public File currentErrorFile() {
        return new File(this.error, this.today() + ".errors");
    }

    private String today() {
        return LocalDate.now(ZoneId.of(ZoneOffset.UTC.getId())).format(Formatter);
    }

    public List<SessionMessageFile> listErrorFiles() {
        return this.listFiles(this.error, ".errors").map(SessionMessageFile::new).collect(Collectors.toList());
    }

    private Stream<File> listFiles(File directory, String extension) {
        File[] children = directory.listFiles(f -> f.getName().endsWith(extension));
        if (children == null) {
            return Stream.empty();
        }
        return Arrays.stream(children).sorted();
    }

    public void mkdirs() {
        this.pending.mkdirs();
        this.processing.mkdirs();
        this.processed.mkdirs();
        this.error.mkdirs();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mailbox mailbox = (Mailbox)o;
        return Objects.equals(this.root, mailbox.root);
    }

    public int hashCode() {
        return Objects.hash(this.root);
    }

    public String toString() {
        return this.root.getPath();
    }
}

