/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.fsm;

import io.intino.alexandria.fsm.Mailbox;
import io.intino.alexandria.fsm.SessionMessageFile;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class IndexFile
implements AutoCloseable {
    private static final int SAVE_FREQUENCY = 500;
    private final File file;
    private volatile long index;
    private volatile boolean closed;

    IndexFile(Mailbox mailbox, SessionMessageFile messageFile) {
        this.file = new File(mailbox.processing(), messageFile.getName() + ".last-index");
        this.index = this.getNextIndex();
    }

    public File file() {
        return this.file;
    }

    public long index() {
        return this.index;
    }

    public void increment() {
        if (++this.index % 500L == 0L) {
            this.save();
        }
    }

    private long getNextIndex() {
        return this.readLastIndex() + 1L;
    }

    private long readLastIndex() {
        if (!this.file.exists()) {
            return -1L;
        }
        try {
            return Long.parseLong(Files.readString(this.file.toPath()));
        }
        catch (IOException | NumberFormatException e) {
            return -1L;
        }
    }

    public void save() {
        if (this.closed) {
            return;
        }
        try {
            Files.writeString(this.file.toPath(), (CharSequence)String.valueOf(this.index), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public void delete() {
        this.file.delete();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.save();
        this.delete();
        this.closed = true;
    }
}

