/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.filemap;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Comparator;

public class FileMap {
    private Index index;
    private Data data;
    private final Object object = new Object();

    public FileMap() {
        this.index = new Index();
        this.data = new Data();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, String value) {
        Object object = this.object;
        synchronized (object) {
            this.index.put(key, this.data.put(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        Object object = this.object;
        synchronized (object) {
            return this.data.get(this.index.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOrDefault(String key, String defaultValue) {
        Object object = this.object;
        synchronized (object) {
            return this.containsKey(key) ? this.data.get(this.index.get(key)) : defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.object;
        synchronized (object) {
            return this.index.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.object;
        synchronized (object) {
            return this.index.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        Object object = this.object;
        synchronized (object) {
            return this.index.containsKey(key);
        }
    }

    public void close() {
        this.data.close();
    }

    private static class Data {
        private RandomAccessFile file;

        Data() {
            try {
                this.file = new RandomAccessFile(this.temp(), "rw");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        long put(String value) {
            try {
                long pos = this.pos();
                this.file.seek(pos);
                this.file.writeUTF(value);
                return pos;
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1L;
            }
        }

        String get(long pos) {
            if (pos < 0L) {
                return null;
            }
            try {
                this.file.seek(pos);
                return this.file.readUTF();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        void close() {
            try {
                this.file.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private File temp() throws IOException {
            File tempFile = File.createTempFile("fileMap", ".db");
            tempFile.deleteOnExit();
            return tempFile;
        }

        private long pos() throws IOException {
            return this.file.length();
        }
    }

    private static class Index {
        private static final Comparator<long[]> comparator = Comparator.comparingLong(o -> o[0]);
        private static ArrayList<long[]> tuples = new ArrayList();
        private boolean sorted = false;

        private Index() {
        }

        void put(String key, long value) {
            this.sorted = false;
            this.put(this.hashCodeOf(key), value);
        }

        long get(String key) {
            if (!this.sorted) {
                this.sort();
            }
            return this.get(this.hashCodeOf(key));
        }

        private void put(long ... item) {
            tuples.add(item);
        }

        private void sort() {
            tuples.sort(comparator);
            this.sorted = true;
        }

        private long get(long key) {
            int low = 0;
            int high = tuples.size() - 1;
            while (low <= high) {
                int idx = low + high >>> 1;
                long[] item = tuples.get(idx);
                long cmp = item[0] - key;
                if (cmp < 0L) {
                    low = idx + 1;
                    continue;
                }
                if (cmp > 0L) {
                    high = idx - 1;
                    continue;
                }
                return item[1];
            }
            return -1L;
        }

        private long hashCodeOf(String key) {
            long h = 1125899906842597L;
            int len = key.length();
            for (int i = 0; i < len; ++i) {
                h = 31L * h + (long)key.charAt(i);
            }
            return h;
        }

        int size() {
            return tuples.size();
        }

        boolean isEmpty() {
            return tuples.isEmpty();
        }

        boolean containsKey(String key) {
            return this.get(key) != -1L;
        }
    }
}

