/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event.message;

import io.intino.alexandria.event.EventReader;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.alexandria.zim.ZimStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class MessageEventReader
implements EventReader<MessageEvent> {
    private final Iterator<MessageEvent> iterator;

    public MessageEventReader(File file) throws IOException {
        this(new MessageToEventIterator(ZimStream.of((File)file).iterator()));
    }

    public MessageEventReader(InputStream is) throws IOException {
        this(new MessageToEventIterator(ZimStream.of((InputStream)is).iterator()));
    }

    public MessageEventReader(String text) {
        this(new MessageToEventIterator(new MessageReader(text).iterator()));
    }

    public MessageEventReader(MessageEvent ... events) {
        this(Arrays.stream(events));
    }

    public MessageEventReader(List<MessageEvent> events) {
        this(events.stream());
    }

    public MessageEventReader(Stream<MessageEvent> stream) {
        this(stream.sorted().iterator());
    }

    public MessageEventReader(Iterator<MessageEvent> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public MessageEvent next() {
        return this.iterator.next();
    }

    @Override
    public void close() throws Exception {
        if (this.iterator instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.iterator)).close();
        }
    }

    private static class MessageToEventIterator
    implements Iterator<MessageEvent>,
    AutoCloseable {
        private final Iterator<Message> source;

        public MessageToEventIterator(Iterator<Message> source) {
            this.source = source;
        }

        @Override
        public void close() throws Exception {
            if (this.source instanceof AutoCloseable) {
                ((AutoCloseable)((Object)this.source)).close();
            }
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public MessageEvent next() {
            return new MessageEvent(this.source.next());
        }
    }
}

