/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event.measurement;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.message.Message;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class MeasurementEvent
implements Event {
    private static final String MEASUREMENT_SEP = "|";
    private static final String ATTRIBUTE_SEP = ":";
    protected final String type;
    protected final String source;
    protected final Instant ts;
    protected final Measurement[] measurements;
    protected final double[] values;

    public MeasurementEvent(String type, String source, Instant ts, String[] measurements, double[] values) {
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.source = Objects.requireNonNull(source, "source cannot be null");
        this.ts = Objects.requireNonNull(ts, "ts cannot be null");
        this.measurements = this.loadMeasurements(measurements);
        this.values = values;
    }

    public MeasurementEvent(String type, String source, Instant ts, Measurement[] measurements, double[] values) {
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.source = Objects.requireNonNull(source, "source cannot be null");
        this.ts = Objects.requireNonNull(ts, "ts cannot be null");
        this.measurements = measurements;
        this.values = values;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public Instant ts() {
        return this.ts;
    }

    @Override
    public String ss() {
        return this.source;
    }

    public Measurement[] measurements() {
        return this.measurements;
    }

    public double[] values() {
        return this.values;
    }

    @Override
    public Event.Format format() {
        return Event.Format.Measurement;
    }

    private Measurement[] loadMeasurements(String[] measurements) {
        return (Measurement[])Arrays.stream(measurements).map(m -> m.split("\\|")).map(fs -> new Measurement(fs[0], ((String[])fs).length > 1 ? this.attributesOf((String[])fs) : new Measurement.Attribute[]{})).toArray(Measurement[]::new);
    }

    private Measurement.Attribute[] attributesOf(String[] fs) {
        return (Measurement.Attribute[])Arrays.stream(fs).skip(1L).map(f -> new Measurement.Attribute(f.split(ATTRIBUTE_SEP))).toArray(Measurement.Attribute[]::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasurementEvent that = (MeasurementEvent)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.source, that.source) && Objects.equals(this.ts, that.ts);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.source, this.ts);
    }

    public String toString() {
        Message message = new Message(this.type());
        message.set("ss", this.ss());
        message.set("ts", (Object)this.ts());
        message.set("measurements", Arrays.stream(this.measurements).map(Measurement::toString).collect(Collectors.toList()));
        message.set("values", (Object)this.values);
        return message.toString();
    }

    public static class Measurement {
        private final String name;
        private final Attribute[] attributes;

        public Measurement(String name, Attribute[] attributes) {
            this.name = name;
            this.attributes = attributes;
        }

        public String name() {
            return this.name;
        }

        public Attribute[] attributes() {
            return this.attributes;
        }

        public String toString() {
            String attributes = Arrays.stream(this.attributes).map(Attribute::toString).collect(Collectors.joining(MeasurementEvent.MEASUREMENT_SEP));
            return this.name + (String)(this.attributes.length > 0 ? MeasurementEvent.MEASUREMENT_SEP + attributes : "");
        }

        public static class Attribute {
            public final String name;
            public final String value;

            public Attribute(String[] nameValue) {
                this.name = nameValue[0];
                this.value = nameValue.length > 1 ? nameValue[1] : null;
            }

            public String name() {
                return this.name;
            }

            public String value() {
                return this.value;
            }

            public String toString() {
                return this.name + MeasurementEvent.ATTRIBUTE_SEP + this.value;
            }
        }
    }
}

