/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event.resource;

import io.intino.alexandria.Resource;
import io.intino.alexandria.event.EventReader;
import io.intino.alexandria.event.resource.ResourceHelper;
import io.intino.alexandria.event.resource.ZipFileEntryInputStream;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.resourcecleaner.DisposableResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipResourceReader
implements Iterator<Resource>,
AutoCloseable {
    private final DisposableResource resource;
    private final ZipInputStream zip;
    private final File file;
    private ZipEntry nextEntry;

    public ZipResourceReader(File file) throws IOException {
        this(EventReader.IO.open(file), file);
    }

    public ZipResourceReader(InputStream inputStream) throws IOException {
        this(ZipResourceReader.zip(inputStream));
    }

    public ZipResourceReader(InputStream inputStream, File file) throws IOException {
        this(ZipResourceReader.zip(inputStream), file);
    }

    public ZipResourceReader(ZipInputStream zip) throws IOException {
        this(zip, null);
    }

    public ZipResourceReader(ZipInputStream zip, File file) throws IOException {
        this.resource = DisposableResource.whenDestroyed((Object)this).thenClose((Object)zip);
        this.zip = Objects.requireNonNull(zip);
        this.nextEntry = zip.getNextEntry();
        this.file = file;
    }

    @Override
    public boolean hasNext() {
        return this.nextEntry != null;
    }

    @Override
    public Resource next() {
        ZipEntry next = this.nextEntry;
        this.tryAdvance();
        return this.toResource(next);
    }

    private Resource toResource(ZipEntry entry) {
        Map<String, String> metadata = ResourceHelper.deserializeMetadata(entry.getExtra());
        if (this.file != null) {
            metadata.put("$file", this.file.getAbsolutePath());
        }
        String name = entry.getName().substring(entry.getName().indexOf("$") + 1);
        Resource resource = new Resource(name, this.inputStreamProviderOf(metadata, entry.getName()));
        resource.metadata().putAll(metadata);
        return resource;
    }

    private Resource.InputStreamProvider inputStreamProviderOf(Map<String, String> metadata, String entryName) {
        try {
            return metadata.containsKey("$file") ? this.openZipFileEntry(metadata.get("$file"), entryName) : this.readFromMemory();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return () -> new ByteArrayInputStream(new byte[0]);
        }
    }

    private Resource.InputStreamProvider readFromMemory() throws IOException {
        byte[] bytes = this.zip.readAllBytes();
        return () -> new ByteArrayInputStream(bytes);
    }

    private Resource.InputStreamProvider openZipFileEntry(String filename, String entryName) {
        return () -> new ZipFileEntryInputStream(filename, entryName);
    }

    @Override
    public void close() throws Exception {
        this.zip.close();
        this.resource.close();
    }

    private void tryAdvance() {
        this.nextEntry = null;
        try {
            this.nextEntry = this.zip.getNextEntry();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ZipInputStream zip(InputStream inputStream) {
        return inputStream instanceof ZipInputStream ? (ZipInputStream)inputStream : new ZipInputStream(inputStream);
    }
}

