/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event.resource;

import io.intino.alexandria.Json;
import io.intino.alexandria.event.resource.ResourceEvent;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

class ResourceHelper {
    static final String METADATA_TYPE = "$type";
    static final String METADATA_SS = "$ss";
    static final String METADATA_TS = "$ts";
    static final String METADATA_REI = "$rei";
    static final String METADATA_FILE = "$file";

    ResourceHelper() {
    }

    static byte[] serializeMetadata(ResourceEvent event, File file) {
        HashMap<String, String> metadata = new HashMap<String, String>(event.resource().metadata().properties());
        metadata.put(METADATA_TYPE, event.type());
        metadata.put(METADATA_SS, event.ss());
        metadata.put(METADATA_TS, event.ts().toString());
        metadata.put(METADATA_REI, event.getREI().toString());
        if (file != null) {
            metadata.put(METADATA_FILE, file.getAbsolutePath());
        }
        return Json.toJson(metadata).getBytes(StandardCharsets.UTF_8);
    }

    static Map<String, String> deserializeMetadata(byte[] bytes) {
        return (Map)Json.fromJson((String)new String(bytes, StandardCharsets.UTF_8), Map.class);
    }
}

