/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventReader;
import io.intino.alexandria.iteratorstream.ResourceIteratorStream;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.BaseStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class EventStream<T extends Event>
extends ResourceIteratorStream<T> {
    public static <T extends Event> Stream<T> sequence(Stream<Stream<T>> streams) {
        return streams.flatMap(Function.identity());
    }

    public static <T extends Event> Stream<T> merge(Stream<Stream<T>> streams) {
        return new EventStream<T>(new MergeIterator<T>(streams));
    }

    public static <T extends Event> Stream<T> of(File file) throws IOException {
        return new EventStream(EventReader.of(file));
    }

    public EventStream(Iterator<T> iterator) {
        super(iterator);
    }

    private static class MergeIterator<T extends Event>
    implements Iterator<T>,
    AutoCloseable {
        private final Iterator<T>[] inputs;
        private final Event[] current;

        public MergeIterator(Stream<Stream<T>> streams) {
            this.inputs = (Iterator[])streams.map(BaseStream::iterator).toArray(Iterator[]::new);
            this.current = (Event[])Arrays.stream(this.inputs).map(this::next).toArray(Event[]::new);
        }

        @Override
        public boolean hasNext() {
            return !Arrays.stream(this.current).allMatch(Objects::isNull);
        }

        @Override
        public T next() {
            return this.next(this.minIndex());
        }

        private T next(int index) {
            Event message = this.current[index];
            this.current[index] = this.next(this.inputs[index]);
            return (T)message;
        }

        private T next(Iterator<T> input) {
            return (T)(input.hasNext() ? (Event)input.next() : null);
        }

        private int minIndex() {
            return IntStream.range(0, this.current.length).boxed().min(this::comparingTimestamp).orElse(-1);
        }

        private int comparingTimestamp(int a, int b) {
            return this.tsOf(this.current[a]).compareTo(this.tsOf(this.current[b]));
        }

        private Instant tsOf(Event event) {
            return event != null ? event.ts() : Instant.MAX;
        }

        @Override
        public void close() throws Exception {
            Exception e = null;
            for (Iterator<T> iterator : this.inputs) {
                e = this.tryClose(iterator);
            }
            if (e != null) {
                throw e;
            }
        }

        private Exception tryClose(Iterator<T> iterator) {
            if (iterator instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)iterator)).close();
                }
                catch (Exception e) {
                    return e;
                }
            }
            return null;
        }
    }
}

