/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventReader;
import io.intino.alexandria.event.EventStream;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;

public class EventWriter {
    private final File source;

    public EventWriter(File file) {
        this.source = file;
        file.getParentFile().mkdirs();
    }

    public void put(Event ... messages) {
        this.put(new EventReader(messages));
    }

    public void put(List<Event> messages) {
        this.put(new EventReader(messages));
    }

    public void put(Stream<Event> stream) {
        this.put(new EventReader(stream));
    }

    public void put(EventStream eventStream) {
        try {
            Files.move(this.merge(eventStream).toPath(), this.source.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private File merge(EventStream data) {
        File file = this.tempFile();
        try (MessageWriter writer = new MessageWriter((OutputStream)this.zipStream(file));){
            EventStream stream = this.mergeFileWith(data);
            while (stream.hasNext()) {
                writer.write(stream.next().toMessage());
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        return file;
    }

    private GZIPOutputStream zipStream(File file) throws IOException {
        return new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    private File tempFile() {
        try {
            return File.createTempFile("eventwriter#", ".zim");
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return new File("eventwriter#" + UUID.randomUUID().toString() + ".zim");
        }
    }

    private EventStream mergeFileWith(EventStream data) {
        return new EventStream.Merge(new EventReader(this.source), data);
    }
}

