/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.dotx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class DocxBuilder {
    private static final String CRLF = "</w:t></w:r><w:r><w:rPr><w:noProof/><w:sz w:val=\"16\"/><w:szCs w:val=\"16\"/></w:rPr><w:br/></w:r><w:r><w:rPr><w:noProof/><w:sz w:val=\"16\"/><w:szCs w:val=\"16\"/></w:rPr><w:t>";
    private final File template;
    private final Content content;

    public static DocxBuilder create(File template) {
        return new DocxBuilder(template);
    }

    public DocxBuilder replace(String replacements) {
        for (String line : replacements.split("\n")) {
            this.content.put(line.split(":"));
        }
        return this;
    }

    public DocxBuilder replace(String field, String value) {
        this.content.put(field, value);
        return this;
    }

    public DocxBuilder replace(String field, byte[] value) {
        this.content.put(field, value);
        return this;
    }

    public void save(File file) throws IOException {
        new Zip(this.template).to(file);
    }

    private DocxBuilder(File template) {
        this.template = template;
        this.content = new Content();
    }

    private static class Buffer {
        private byte[] buffer = new byte[32768];
        private int length;

        private Buffer() {
        }

        boolean read(InputStream is) throws IOException {
            this.length = is.read(this.buffer);
            return this.length > 0;
        }

        void write(OutputStream os) throws IOException {
            os.write(this.buffer, 0, this.length);
        }
    }

    private final class Zip {
        private final ZipFile zin;
        private final Enumeration<? extends ZipEntry> entries;

        Zip(File template) throws IOException {
            this.zin = new ZipFile(template);
            this.entries = this.zin.entries();
        }

        void to(File result) throws IOException {
            try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(result));){
                while (this.entries.hasMoreElements()) {
                    this.create(zos, new ZipEntry(this.entries.nextElement().getName()));
                }
            }
            this.close();
        }

        void close() throws IOException {
            this.zin.close();
        }

        private void create(ZipOutputStream zos, ZipEntry entry) throws IOException {
            zos.putNextEntry(entry);
            this.copy(entry, zos);
            zos.closeEntry();
        }

        private void copy(ZipEntry entry, ZipOutputStream zos) throws IOException {
            if (this.isDocument(entry)) {
                this.replaceDocument(this.zin.getInputStream(entry), zos);
            } else if (this.isReplacedImage(entry)) {
                zos.write(this.imageOf(entry));
            } else {
                this.copyFile(this.zin.getInputStream(entry), zos);
            }
        }

        private byte[] imageOf(ZipEntry entry) {
            return DocxBuilder.this.content.image(entry.getName().substring(11));
        }

        private boolean isReplacedImage(ZipEntry entry) {
            if (!entry.getName().startsWith("word/media/")) {
                return false;
            }
            return DocxBuilder.this.content.hasImage(entry.getName().substring(11));
        }

        private boolean isDocument(ZipEntry entry) {
            return entry.getName().equalsIgnoreCase("word/document.xml");
        }

        private void copyFile(InputStream is, ZipOutputStream zos) throws IOException {
            Buffer buffer = new Buffer();
            while (buffer.read(is)) {
                buffer.write(zos);
            }
            is.close();
        }

        private void replaceDocument(InputStream is, ZipOutputStream zos) throws IOException {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line;
                while ((line = reader.readLine()) != null) {
                    zos.write(DocxBuilder.this.content.replace(line).getBytes());
                }
            }
        }
    }

    private static final class Content {
        private final Map<String, String> fields = new HashMap<String, String>();
        private final Map<String, byte[]> images = new HashMap<String, byte[]>();

        Content() {
        }

        private String fieldOf(String key) {
            return this.tagOf("\u00ab" + key + "\u00bb");
        }

        private String valueOf(String key) {
            return this.tagOf(this.fields.get(key)).replace("\n", DocxBuilder.CRLF).replace("&", "&amp;");
        }

        private String tagOf(String name) {
            return "<w:t>" + name + "</w:t>";
        }

        void put(String field, String value) {
            this.fields.put(field, value);
        }

        void put(String field, byte[] value) {
            this.images.put(field, value);
        }

        void put(String[] data) {
            this.fields.put(data[0], data[1]);
        }

        String replace(String line) {
            for (String key : this.fields.keySet()) {
                line = line.replace(this.fieldOf(key), this.valueOf(key));
            }
            return line;
        }

        byte[] image(String name) {
            return this.images.get(name);
        }

        public boolean hasImage(String name) {
            return this.images.containsKey(name);
        }
    }
}

