/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file.resource;

import io.intino.alexandria.FS;
import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FileStore;
import io.intino.alexandria.datalake.file.resource.ResourceEventTank;
import io.intino.alexandria.datalake.file.resource.ResourceEventTub;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.resource.ResourceEvent;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class ResourceEventStore
implements Datalake.ResourceStore,
FileStore {
    private final File root;

    public ResourceEventStore(File root) {
        this.root = root;
    }

    @Override
    public Optional<ResourceEvent> find(ResourceEvent.REI rei) {
        try {
            Scale scale = this.scale();
            if (scale == null) {
                return Optional.empty();
            }
            Timetag timetag = Timetag.of((Instant)rei.ts(), (Scale)scale);
            return this.findResourceEvent(rei, timetag);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<ResourceEvent> findResourceEvent(ResourceEvent.REI rei, Timetag timetag) {
        File tub = new File(this.root, rei.type() + "/" + rei.ss() + "/" + timetag + this.fileExtension());
        if (tub.exists()) {
            return new ResourceEventTub(tub).find(rei);
        }
        return this.findEventInTanks(rei, timetag);
    }

    private Optional<ResourceEvent> findEventInTanks(ResourceEvent.REI rei, Timetag timetag) {
        return this.tanks().filter(t -> t.name().endsWith(rei.type())).filter(t -> t.source(rei.ss()) != null).map(t -> t.source(rei.ss()).tub(timetag)).filter(Objects::nonNull).filter(t -> t instanceof ResourceEventTub).map(t -> ((ResourceEventTub)t).find(rei)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    @Override
    public Stream<Datalake.Store.Tank<ResourceEvent>> tanks() {
        return FS.directoriesIn((File)this.root).map(ResourceEventTank::new);
    }

    @Override
    public File directory() {
        return this.root;
    }

    public ResourceEventTank tank(String name) {
        return new ResourceEventTank(new File(this.root, name));
    }

    @Override
    public String fileExtension() {
        return Event.Format.Resource.extension();
    }
}

