/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file.resource;

import io.intino.alexandria.FS;
import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FileStore;
import io.intino.alexandria.datalake.file.resource.ResourceEventTank;
import io.intino.alexandria.datalake.file.resource.ResourceEventTub;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.resource.ResourceEvent;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.time.Instant;
import java.util.Optional;
import java.util.stream.Stream;

public class ResourceEventStore
implements Datalake.ResourceStore,
FileStore {
    private final File root;

    public ResourceEventStore(File root) {
        this.root = root;
    }

    @Override
    public Optional<ResourceEvent> find(ResourceEvent.REI rei) {
        try {
            Scale scale = this.scale();
            if (scale == null) {
                return Optional.empty();
            }
            File tub = new File(this.root, rei.type() + "/" + rei.ss() + "/" + Timetag.of((Instant)rei.ts(), (Scale)scale) + this.fileExtension());
            return tub.exists() ? new ResourceEventTub(tub).find(rei) : Optional.empty();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Stream<Datalake.Store.Tank<ResourceEvent>> tanks() {
        return FS.directoriesIn((File)this.root).map(ResourceEventTank::new);
    }

    @Override
    public File directory() {
        return this.root;
    }

    public ResourceEventTank tank(String name) {
        return new ResourceEventTank(new File(this.root, name));
    }

    @Override
    public String fileExtension() {
        return Event.Format.Resource.extension();
    }
}

