/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file.resource;

import io.intino.alexandria.FS;
import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.resource.ResourceEventTub;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.resource.ResourceEvent;
import java.io.File;
import java.util.Optional;
import java.util.stream.Stream;

public class ResourceEventSource
implements Datalake.Store.Source<ResourceEvent> {
    private final File root;

    public ResourceEventSource(File file) {
        this.root = file;
    }

    @Override
    public String name() {
        return this.root.getName();
    }

    @Override
    public Scale scale() {
        return Optional.ofNullable(this.first()).map(Datalake.Store.Tub::scale).orElse(null);
    }

    @Override
    public Datalake.Store.Tub<ResourceEvent> first() {
        return this.tubs().findFirst().orElse(null);
    }

    @Override
    public Datalake.Store.Tub<ResourceEvent> last() {
        File[] files = (File[])this.tubFiles().toArray(File[]::new);
        return files.length == 0 ? null : new ResourceEventTub(files[files.length - 1]);
    }

    @Override
    public Stream<Datalake.Store.Tub<ResourceEvent>> tubs() {
        return this.tubFiles().map(ResourceEventTub::new);
    }

    @Override
    public Datalake.Store.Tub<ResourceEvent> on(Timetag tag) {
        return new ResourceEventTub(new File(this.root, tag.value() + Event.Format.Resource.extension()));
    }

    private Stream<File> tubFiles() {
        return FS.filesIn((File)this.root, pathname -> pathname.getName().endsWith(Event.Format.Resource.extension()));
    }
}

