/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file.resource;

import io.intino.alexandria.Json;
import io.intino.alexandria.Resource;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.FileTub;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventStream;
import io.intino.alexandria.event.resource.ResourceEvent;
import io.intino.alexandria.event.resource.ZipFileEntryInputStream;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ResourceEventTub
implements Datalake.Store.Tub<ResourceEvent>,
FileTub {
    private final File zip;

    public ResourceEventTub(File zip) {
        this.zip = zip;
    }

    public String name() {
        return this.zip.getName().replace(Event.Format.Resource.extension(), "");
    }

    @Override
    public Timetag timetag() {
        return new Timetag(this.name());
    }

    @Override
    public Stream<ResourceEvent> events() {
        try {
            return EventStream.of((File)this.zip);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return Stream.empty();
        }
    }

    public List<ResourceEvent> findAll(String resourceName) {
        List<ResourceEvent> list;
        String suffix = "$" + resourceName;
        ZipFile zipFile = new ZipFile(this.zip);
        try {
            list = zipFile.stream().filter(entry -> entry.getName().endsWith(suffix)).map(entry -> this.toResourceEvent(resourceName, (ZipEntry)entry)).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return new ArrayList<ResourceEvent>(0);
            }
        }
        zipFile.close();
        return list;
    }

    public Optional<ResourceEvent> find(ResourceEvent.REI rei) {
        Optional<ResourceEvent> optional;
        ZipFile zipFile = new ZipFile(this.zip);
        try {
            ZipEntry entry = zipFile.getEntry(rei.resourceId());
            optional = entry == null ? Optional.empty() : Optional.of(this.toResourceEvent(rei.resourceName(), entry));
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return Optional.empty();
            }
        }
        zipFile.close();
        return optional;
    }

    private ResourceEvent toResourceEvent(String resourceName, ZipEntry entry) {
        Map metadata = (Map)Json.fromJson((String)new String(entry.getExtra(), StandardCharsets.UTF_8), Map.class);
        Resource resource = new Resource(resourceName, () -> new ZipFileEntryInputStream(new ZipFile(this.zip), entry));
        resource.metadata().putAll(metadata);
        return ResourceEvent.of((Resource)resource);
    }

    @Override
    public String fileExtension() {
        return Event.Format.Resource.extension();
    }

    @Override
    public File file() {
        return this.zip;
    }
}

