/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileEntityTub
implements Datalake.EntityStore.Tub {
    private final File tsv;

    public FileEntityTub(File tsv) {
        this.tsv = tsv;
    }

    public String name() {
        return this.tsv.getName().replace(".triplets", "");
    }

    @Override
    public Timetag timetag() {
        return new Timetag(this.name());
    }

    @Override
    public Scale scale() {
        return this.timetag().scale();
    }

    @Override
    public Stream<Datalake.EntityStore.Triplet> triplets() {
        Stream<Datalake.EntityStore.Triplet> stream;
        block8: {
            Stream<String> lines = Files.lines(this.tsv.toPath());
            try {
                stream = lines.filter(line -> !line.isEmpty()).map(l -> new Datalake.EntityStore.Triplet(l.split("\t", -1))).collect(Collectors.toList()).stream();
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.error((Throwable)e);
                    return Stream.empty();
                }
            }
            lines.close();
        }
        return stream;
    }

    @Override
    public Stream<Datalake.EntityStore.Triplet> triplets(Predicate<Datalake.EntityStore.Triplet> filter) {
        return this.triplets().filter(filter);
    }
}

