/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FS;
import io.intino.alexandria.datalake.file.FileEntityTub;
import java.io.File;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FileEntityTank
implements Datalake.EntityStore.Tank {
    private final File root;

    public FileEntityTank(File root) {
        this.root = root;
    }

    @Override
    public String name() {
        return this.root.getName();
    }

    @Override
    public Datalake.EntityStore.Tub first() {
        return this.tubs().findFirst().orElse(null);
    }

    @Override
    public Datalake.EntityStore.Tub last() {
        return this.tubFiles().map(FileEntityTub::new).findFirst().orElse(null);
    }

    @Override
    public Stream<Datalake.EntityStore.Tub> tubs() {
        return this.tubFiles().map(FileEntityTub::new);
    }

    @Override
    public Stream<Datalake.EntityStore.Tub> tubs(int count) {
        return this.tubFiles().map(f -> new FileEntityTub((File)f)).limit(count);
    }

    private Stream<File> tubFiles() {
        return FS.filesIn(this.root, pathname -> pathname.getName().endsWith(".triplets"));
    }

    @Override
    public Stream<Datalake.EntityStore.Tub> tubs(Timetag from, Timetag to) {
        return StreamSupport.stream(from.iterateTo(to).spliterator(), false).map(this::on);
    }

    @Override
    public Datalake.EntityStore.Tub on(Timetag tag) {
        return new FileEntityTub(new File(this.root, tag.value()));
    }

    public File root() {
        return this.root;
    }
}

