/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FS;
import io.intino.alexandria.datalake.file.FileEventTub;
import java.io.File;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileEventTank
implements Datalake.EventStore.Tank {
    private final File root;

    FileEventTank(File root) {
        this.root = root;
    }

    @Override
    public String name() {
        return this.root.getName();
    }

    @Override
    public Scale scale() {
        return this.first().timetag().scale();
    }

    @Override
    public Stream<Datalake.EventStore.Tub> tubs() {
        return this.tubFiles().map(FileEventTub::new);
    }

    @Override
    public Datalake.EventStore.Tub first() {
        return this.tubs().findFirst().orElse(this.currentTub());
    }

    @Override
    public Datalake.EventStore.Tub last() {
        List files = this.tubFiles().collect(Collectors.toList());
        return files.isEmpty() ? null : new FileEventTub((File)files.get(files.size() - 1));
    }

    @Override
    public Datalake.EventStore.Tub on(Timetag tag) {
        return new FileEventTub(new File(this.root, tag.value() + ".zim"));
    }

    public File root() {
        return this.root;
    }

    private Stream<File> tubFiles() {
        return FS.filesIn(this.root, pathname -> pathname.getName().endsWith(".zim"));
    }

    private FileEventTub currentTub() {
        return new FileEventTub(new File(this.root, new Timetag(LocalDateTime.now(), Scale.Month).toString()));
    }
}

