/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.EventStream;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface Datalake {
    public static final String EventStoreFolder = "events";
    public static final String TripletStoreFolder = "triplets";

    public EventStore eventStore();

    public TripletStore tripletsStore();

    public static interface TripletStore {
        public Stream<Tank> tanks();

        public Tank tank(String var1);

        public static class Triplet {
            String[] fields;

            public Triplet(String[] fields) {
                this.fields = fields;
            }

            public String subject() {
                return this.fields[0];
            }

            public String verb() {
                return this.fields[1];
            }

            public String object() {
                return this.fields[2];
            }

            public String author() {
                return this.fields.length > 3 ? this.fields[3] : null;
            }

            public String get(int index) {
                return this.fields[index];
            }

            public String toString() {
                return String.join((CharSequence)"\t", this.fields);
            }
        }

        public static interface Tub {
            public Timetag timetag();

            public Scale scale();

            public Stream<Triplet> triplets();

            public Stream<Triplet> triplets(Predicate<Triplet> var1);
        }

        public static interface Tank {
            public String name();

            public Stream<Tub> tubs();

            public Tub first();

            public Tub last();

            public Tub on(Timetag var1);

            public Stream<Tub> tubs(int var1);

            public Stream<Tub> tubs(Timetag var1, Timetag var2);
        }
    }

    public static interface EventStore {
        public Stream<Tank> tanks();

        public Tank tank(String var1);

        public static interface Tub {
            public Timetag timetag();

            public EventStream events();
        }

        public static interface Tank {
            public String name();

            public Scale scale();

            public Stream<Tub> tubs();

            public Tub first();

            public Tub last();

            public Tub on(Timetag var1);

            default public EventStream content() {
                return EventStream.Sequence.of((EventStream[])((EventStream[])this.tubs().map(Tub::events).toArray(EventStream[]::new)));
            }

            default public EventStream content(Predicate<Timetag> filter) {
                return EventStream.Sequence.of((EventStream[])((EventStream[])this.tubs().filter(t -> filter.test(t.timetag())).map(Tub::events).toArray(EventStream[]::new)));
            }
        }
    }
}

