/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FileEventStore;
import io.intino.alexandria.datalake.file.FileTripletStore;
import java.io.File;

public class FileDatalake
implements Datalake {
    private final File root;

    public FileDatalake(File root) {
        this.root = root;
        this.checkStore();
    }

    private void checkStore() {
        this.tripletStoreFolder().mkdirs();
        this.eventStoreFolder().mkdirs();
    }

    @Override
    public FileEventStore eventStore() {
        return new FileEventStore(this.eventStoreFolder());
    }

    @Override
    public FileTripletStore tripletsStore() {
        return new FileTripletStore(this.tripletStoreFolder());
    }

    public File root() {
        return this.root;
    }

    public File eventStoreFolder() {
        return new File(this.root, "events");
    }

    public File tripletStoreFolder() {
        return new File(this.root, "triplets");
    }
}

