/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class FileTripletTub
implements Datalake.TripletStore.Tub {
    private final File tsv;

    public FileTripletTub(File tsv) {
        this.tsv = tsv;
    }

    public String name() {
        return this.tsv.getName().replace(".tsv", "");
    }

    @Override
    public Timetag timetag() {
        return new Timetag(this.name());
    }

    @Override
    public Scale scale() {
        return this.timetag().scale();
    }

    @Override
    public Stream<Datalake.TripletStore.Triplet> triplets() {
        try {
            return Files.lines(this.tsv.toPath()).map(l -> new Datalake.TripletStore.Triplet(l.split("\t")));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return Stream.empty();
        }
    }

    @Override
    public Stream<Datalake.TripletStore.Triplet> triplets(Predicate<Datalake.TripletStore.Triplet> filter) {
        return this.triplets().filter(filter);
    }
}

