/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FS;
import io.intino.alexandria.datalake.file.FileTripletTub;
import java.io.File;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FileTripletTank
implements Datalake.TripletStore.Tank {
    private final File root;

    public FileTripletTank(File root) {
        this.root = root;
    }

    @Override
    public String name() {
        return this.root.getName();
    }

    @Override
    public Datalake.TripletStore.Tub first() {
        return this.tubs().findFirst().orElse(null);
    }

    @Override
    public Datalake.TripletStore.Tub last() {
        return FS.foldersIn(this.root, FS.Sort.Reversed).map(FileTripletTub::new).findFirst().orElse(null);
    }

    @Override
    public Stream<Datalake.TripletStore.Tub> tubs() {
        return FS.foldersIn(this.root).map(FileTripletTub::new);
    }

    @Override
    public Stream<Datalake.TripletStore.Tub> tubs(int count) {
        return FS.foldersIn(this.root, FS.Sort.Reversed).map(f -> new FileTripletTub((File)f)).limit(count);
    }

    @Override
    public Stream<Datalake.TripletStore.Tub> tubs(Timetag from, Timetag to) {
        return StreamSupport.stream(from.iterateTo(to).spliterator(), false).map(this::on);
    }

    @Override
    public Datalake.TripletStore.Tub on(Timetag tag) {
        return new FileTripletTub(new File(this.root, tag.value()));
    }

    public File root() {
        return this.root;
    }
}

