/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FS;
import io.intino.alexandria.datalake.file.FileSet;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.mapp.MappReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class FileSetTub
implements Datalake.SetStore.Tub {
    private final File root;

    public FileSetTub(File root) {
        this.root = root;
    }

    public String name() {
        return this.root.getName();
    }

    @Override
    public Timetag timetag() {
        return new Timetag(this.name());
    }

    @Override
    public Scale scale() {
        return this.timetag().scale();
    }

    @Override
    public MappReader index() {
        try {
            if (!this.indexFile().exists()) {
                return null;
            }
            return new MappReader(this.root.getParentFile().getName() + "-" + this.name(), (InputStream)new FileInputStream(this.indexFile()));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private File indexFile() {
        return new File(this.root, ".mapp");
    }

    @Override
    public Datalake.SetStore.Set set(String set) {
        return new FileSet(new File(this.root, set + ".zet"));
    }

    @Override
    public Stream<Datalake.SetStore.Set> sets() {
        return FS.filesIn(this.root, f -> f.getName().endsWith(".zet")).map(FileSet::new);
    }

    @Override
    public Stream<Datalake.SetStore.Set> sets(Predicate<Datalake.SetStore.Set> filter) {
        return this.sets().filter(filter);
    }
}

