/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FS;
import io.intino.alexandria.datalake.file.FileTransaction;
import java.io.File;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FileTransactionTank
implements Datalake.TransactionStore.Tank {
    private final File root;

    public FileTransactionTank(File root) {
        this.root = root;
    }

    @Override
    public String name() {
        return this.root.getName();
    }

    @Override
    public Datalake.TransactionStore.Transaction first() {
        return this.transactions().findFirst().orElse(this.currentTransaction());
    }

    @Override
    public Datalake.TransactionStore.Transaction last() {
        List files = this.transactionFiles().collect(Collectors.toList());
        return files.isEmpty() ? null : new FileTransaction((File)files.get(files.size() - 1));
    }

    @Override
    public Stream<Datalake.TransactionStore.Transaction> transactions() {
        return this.transactionFiles().map(FileTransaction::new);
    }

    @Override
    public Stream<Datalake.TransactionStore.Transaction> transactions(Timetag from, Timetag to) {
        return StreamSupport.stream(from.iterateTo(to).spliterator(), false).map(this::on).filter(Objects::nonNull);
    }

    @Override
    public Datalake.TransactionStore.Transaction on(Timetag tag) {
        File file = new File(this.root, tag.value() + ".led");
        return file.exists() ? new FileTransaction(file) : null;
    }

    public File root() {
        return this.root;
    }

    private FileTransaction currentTransaction() {
        return new FileTransaction(new File(this.root, new Timetag(LocalDateTime.now(), Scale.Month).toString() + ".led"));
    }

    private Stream<File> transactionFiles() {
        return FS.filesIn(this.root, path -> path.getName().endsWith(".led"));
    }
}

