/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FS;
import io.intino.alexandria.datalake.file.FileTransaction;
import java.io.File;
import java.time.LocalDateTime;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FileTransactionTank
implements Datalake.TransactionStore.Tank {
    private final File root;

    public FileTransactionTank(File root) {
        this.root = root;
    }

    @Override
    public String name() {
        return this.root.getName();
    }

    @Override
    public Datalake.TransactionStore.Transaction first() {
        return this.transactions().findFirst().orElse(this.currentLed());
    }

    @Override
    public Datalake.TransactionStore.Transaction last() {
        return FS.foldersIn(this.root, FS.Sort.Reversed).map(FileTransaction::new).findFirst().orElse(this.currentLed());
    }

    @Override
    public Stream<Datalake.TransactionStore.Transaction> transactions() {
        return FS.foldersIn(this.root).map(FileTransaction::new);
    }

    @Override
    public Stream<Datalake.TransactionStore.Transaction> transactions(Timetag from, Timetag to) {
        return StreamSupport.stream(from.iterateTo(to).spliterator(), false).map(this::on);
    }

    @Override
    public Datalake.TransactionStore.Transaction on(Timetag tag) {
        return new FileTransaction(new File(this.root, tag.value() + ".led"));
    }

    public File root() {
        return this.root;
    }

    private FileTransaction currentLed() {
        return new FileTransaction(new File(this.root, new Timetag(LocalDateTime.now(), Scale.Month).toString() + ".led"));
    }
}

