/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.datalake.file.FileSet;
import io.intino.alexandria.triplestore.FileTripleStore;
import io.intino.alexandria.triplestore.TripleStore;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class FileMetadata {
    private static Map<File, TripleStore> tripleStores = new HashMap<File, TripleStore>();

    public static Stream<String[]> of(FileSet set) {
        return FileMetadata.metadataTripleStoreOf(set).matches(new String[]{set.name()});
    }

    private static TripleStore metadataTripleStoreOf(FileSet set) {
        if (!FileMetadata.isOpenMetadataTripleStoreOf(set)) {
            FileMetadata.openMetadataTripleStoreOf(set);
        }
        return FileMetadata.getMetadataTripleStoreOf(set);
    }

    private static TripleStore getMetadataTripleStoreOf(FileSet set) {
        return tripleStores.get(FileMetadata.metadataFileOf(set));
    }

    private static boolean isOpenMetadataTripleStoreOf(FileSet set) {
        return tripleStores.containsKey(FileMetadata.metadataFileOf(set));
    }

    private static void openMetadataTripleStoreOf(FileSet set) {
        FileTripleStore tripleStore = new FileTripleStore(FileMetadata.metadataFileOf(set));
        tripleStores.put(tripleStore.file(), (TripleStore)tripleStore);
    }

    private static File metadataFileOf(FileSet set) {
        return new File(FileMetadata.tubFolderOf(set.file()), ".metadata");
    }

    private static File tubFolderOf(File file) {
        return file.getParentFile();
    }
}

