/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file.analytics;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class SetAnalytics {
    private Datalake.SetStore setStore;

    public SetAnalytics(Datalake.SetStore setStore) {
        this.setStore = setStore;
    }

    public TankEvolution evolutionOf(String tank, int count) {
        return this.evolutionOf(this.setStore.tank(tank), count);
    }

    public TankHistogram histogramOf(Datalake.SetStore.Tub tub, TankHistogram.Axis axis) {
        return new TankHistogram(axis, tub);
    }

    public TankHistogram histogramOf(String tank, TankHistogram.Axis axis) {
        return this.histogramOf(this.setStore.tank(tank), axis);
    }

    private TankEvolution evolutionOf(Datalake.SetStore.Tank tank, int count) {
        return new TankEvolution(tank.tubs(count));
    }

    private TankHistogram histogramOf(Datalake.SetStore.Tank tank, TankHistogram.Axis axis) {
        return new TankHistogram(axis, tank.last());
    }

    public static class TankEvolution {
        private Stream<Datalake.SetStore.Tub> tubs;

        public TankEvolution(Stream<Datalake.SetStore.Tub> tubs) {
            this.tubs = tubs;
        }

        public Stream<Point> points() {
            return this.points(s -> true);
        }

        public Stream<Point> points(Predicate<Datalake.SetStore.Set> filter) {
            return this.tubs.map(t -> this.point((Datalake.SetStore.Tub)t, filter));
        }

        private Point<Timetag> point(final Datalake.SetStore.Tub tub, final Predicate<Datalake.SetStore.Set> filter) {
            return new Point<Timetag>(){

                @Override
                public Timetag item() {
                    return tub.timetag();
                }

                @Override
                public int size() {
                    return tub.sets(filter).mapToInt(Datalake.SetStore.Set::size).sum();
                }
            };
        }
    }

    public static class TankHistogram<T> {
        private final Axis<T> axis;
        private final Map<T, Integer> data;
        private final Datalake.SetStore.Tub tub;

        public TankHistogram(Axis axis, Datalake.SetStore.Tub tub) {
            this.axis = axis;
            this.data = new HashMap<T, Integer>();
            this.tub = tub;
        }

        public Stream<Point> points() {
            return this.points(Optional.ofNullable(this.tub).map(Datalake.SetStore.Tub::sets).orElse(Stream.empty()));
        }

        public Stream<Point> points(Predicate<Datalake.SetStore.Set> filter) {
            return this.points(Optional.ofNullable(this.tub).map(t -> t.sets(filter)).orElse(Stream.empty()));
        }

        private Stream<Point> points(Stream<Datalake.SetStore.Set> sets) {
            this.fillDataWith(sets);
            return this.data.keySet().stream().sorted(this.axis.sorting()).map(this::pointOf);
        }

        private void fillDataWith(Stream<Datalake.SetStore.Set> sets) {
            this.data.clear();
            sets.forEach(this::put);
        }

        private Point<T> pointOf(final T item) {
            return new Point<T>(){

                @Override
                public T item() {
                    return item;
                }

                @Override
                public int size() {
                    return this.sizeOf(item);
                }
            };
        }

        public void put(Datalake.SetStore.Set set) {
            T item = this.axis.itemOf(set);
            this.data.put(item, this.sizeOf(item) + this.sizeOf(set));
        }

        private Integer sizeOf(T item) {
            return this.data.getOrDefault(item, 0);
        }

        private int sizeOf(Datalake.SetStore.Set set) {
            return set.size();
        }

        public static interface Axis<T> {
            public T itemOf(Datalake.SetStore.Set var1);

            public Comparator<? super T> sorting();
        }
    }

    public static interface Point<T> {
        public T item();

        public int size();
    }
}

