/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FS;
import io.intino.alexandria.datalake.file.FileEventTub;
import io.intino.alexandria.event.EventStream;
import java.io.File;
import java.time.LocalDateTime;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class FileEventTank
implements Datalake.EventStore.Tank {
    private final File root;

    FileEventTank(File root) {
        this.root = root;
    }

    @Override
    public String name() {
        return this.root.getName();
    }

    @Override
    public Scale scale() {
        return this.first().timetag().scale();
    }

    @Override
    public Stream<Datalake.EventStore.Tub> tubs() {
        return FS.filesIn(this.root, pathname -> pathname.getName().endsWith(".zim")).map(FileEventTub::new);
    }

    @Override
    public Datalake.EventStore.Tub first() {
        return this.tubs().findFirst().orElse(this.currentTub());
    }

    @Override
    public Datalake.EventStore.Tub last() {
        return FS.foldersIn(this.root, FS.Sort.Reversed).map(FileEventTub::new).findFirst().orElse(this.currentTub());
    }

    @Override
    public Datalake.EventStore.Tub on(Timetag tag) {
        return new FileEventTub(new File(this.root, tag.value() + ".zim"));
    }

    @Override
    public EventStream content() {
        return EventStream.Sequence.of((EventStream[])((EventStream[])this.tubs().map(Datalake.EventStore.Tub::events).toArray(EventStream[]::new)));
    }

    @Override
    public EventStream content(Predicate<Timetag> filter) {
        return EventStream.Sequence.of((EventStream[])((EventStream[])this.tubs().filter(t -> filter.test(t.timetag())).map(Datalake.EventStore.Tub::events).toArray(EventStream[]::new)));
    }

    public File root() {
        return this.root;
    }

    private FileEventTub currentTub() {
        return new FileEventTub(new File(this.root, new Timetag(LocalDateTime.now(), Scale.Month).toString()));
    }
}

