/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FileMetadata;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zet.ZFile;
import io.intino.alexandria.zet.ZetReader;
import io.intino.alexandria.zet.ZetStream;
import java.io.File;
import java.io.IOException;
import java.util.stream.Stream;

public class FileSet
implements Datalake.SetStore.Set {
    private final File file;

    public FileSet(File file) {
        this.file = file;
    }

    @Override
    public String name() {
        return this.file.getName().replace(".zet", "");
    }

    @Override
    public Timetag timetag() {
        return new Timetag(this.file.getParentFile().getName());
    }

    public File file() {
        return this.file;
    }

    @Override
    public int size() {
        try {
            return this.file.exists() ? (int)new ZFile(this.file).size() : 0;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return 0;
        }
    }

    @Override
    public ZetStream content() {
        return new ZetReader(this.file);
    }

    @Override
    public Stream<Datalake.SetStore.Variable> variables() {
        return FileMetadata.of(this).map(a -> new Datalake.SetStore.Variable(a[1], a[2]));
    }

    @Override
    public Datalake.SetStore.Variable variable(String name) {
        return this.variables().filter(v -> v.name.equals(name)).findFirst().orElse(null);
    }
}

