/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FS;
import io.intino.alexandria.zim.ZimReader;
import io.intino.alexandria.zim.ZimStream;
import java.io.File;
import java.util.function.Predicate;

public class FileEventTank
implements Datalake.EventStore.Tank {
    private final File root;

    FileEventTank(File root) {
        this.root = root;
    }

    @Override
    public String name() {
        return this.root.getName();
    }

    @Override
    public ZimStream content() {
        return ZimStream.Sequence.of((ZimStream[])this.zimStreams(t -> true));
    }

    @Override
    public ZimStream content(Predicate<Timetag> filter) {
        return ZimStream.Sequence.of((ZimStream[])this.zimStreams(filter));
    }

    public File root() {
        return this.root;
    }

    private ZimStream[] zimStreams(Predicate<Timetag> filter) {
        return (ZimStream[])FS.filesIn(this.root, f -> f.getName().endsWith(".zim")).sorted().filter(f -> filter.test(this.timetagOf((File)f))).map(ZimReader::new).toArray(ZimStream[]::new);
    }

    private Timetag timetagOf(File file) {
        return new Timetag(file.getName().replace(".zim", ""));
    }
}

