/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core.operation.sourceunit;

import io.intino.tara.builder.core.CompilationUnit;
import io.intino.tara.builder.core.SourceUnit;
import io.intino.tara.builder.core.errorcollection.ErrorCollector;
import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.builder.core.errorcollection.message.Message;
import io.intino.tara.builder.core.operation.sourceunit.SourceUnitOperation;
import io.intino.tara.language.grammar.SyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParseOperation
extends SourceUnitOperation {
    private static final Logger LOG = Logger.getGlobal();
    private final CompilationUnit unit;
    private final ErrorCollector errorCollector;

    public ParseOperation(CompilationUnit unit) {
        this.unit = unit;
        this.errorCollector = unit.getErrorCollector();
    }

    @Override
    public void call(SourceUnit source) {
        try {
            if (this.unit.configuration().isVerbose()) {
                this.unit.configuration().out().println("@#$%@# Presentable:Parsing " + String.valueOf(source.uri()));
            }
            source.parse();
            this.errorCollector.failIfErrors();
        }
        catch (TaraException e) {
            if (e.getCause() instanceof SyntaxException) {
                LOG.log(Level.SEVERE, "Syntax error during Parsing: " + e.getMessage());
                this.errorCollector.addError(Message.create((SyntaxException)e.getCause(), source));
            } else {
                LOG.log(Level.SEVERE, "Error during Parsing: " + e.getMessage());
                this.errorCollector.addError(Message.create(e.getMessage(), source));
            }
        }
        catch (SyntaxException e) {
            LOG.log(Level.SEVERE, "Syntax error during Parsing: " + e.getMessage());
            this.errorCollector.addError(Message.create(e, source));
        }
    }
}

