/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.builder.core;

import io.intino.builder.CompilerConfiguration;
import io.intino.tara.Source;
import io.intino.tara.builder.core.ProcessingUnit;
import io.intino.tara.builder.core.errorcollection.ErrorCollector;
import io.intino.tara.builder.core.errorcollection.TaraException;
import io.intino.tara.language.grammar.SyntaxException;
import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.processors.model.Model;
import io.intino.tara.processors.parser.Parser;
import java.net.URI;

public class SourceUnit
extends ProcessingUnit {
    private final Source source;
    private Model model;
    private Parser parser;
    private TaraGrammar.RootContext tree;

    public SourceUnit(Source source, CompilerConfiguration configuration, ErrorCollector er) {
        super(configuration, er);
        this.source = source;
        this.configuration = configuration;
        this.errorCollector = er;
    }

    public URI uri() {
        return this.source.uri();
    }

    public Model model() {
        return this.model;
    }

    public void parse() throws TaraException, SyntaxException {
        if (this.parser == null) {
            this.parser = new Parser(this.source);
            this.tree = this.parser.parse();
        }
    }

    public void importData() throws SyntaxException {
        this.model = this.parser.convert(this.tree);
    }

    public boolean isDirty() {
        return this.source.dirty();
    }
}

